

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">تفاصيل الوردية: <?php echo e($shift->id); ?></h3>
    </div>
    <div class="card-body">

        <!-- Show Shift Begin and End Dates and Times -->
        <h4>تاريخ ووقت بداية الوردية: <?php echo e(\Carbon\Carbon::parse($shift->shift_begin)->locale('ar')->isoFormat('dddd, D MMMM YYYY h:mm A')); ?></h4>
        <h4 style="float:left">تاريخ ووقت نهاية الوردية: <?php echo e($shift->shift_end ? \Carbon\Carbon::parse($shift->shift_end)->locale('ar')->isoFormat('dddd, D MMMM YYYY h:mm A') : 'لم تغلق بعد'); ?></h4>


<br><br><br>

        <!-- Show the Orders (Tickets) -->
        <h4>التذاكر في هذه الوردية</h4>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>رقم الطلب</th>
                    <th>تاريخ الطلب</th>
                    <th>إجمالي الطلب</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><a href="#" onclick="window.open('<?php echo e(url('admin/ticket/' . $order->id)); ?>', '', 'width=400,height=500');"><?php echo e($order->v_id); ?></a></td>
                    <td><?php echo e($order->created_at->locale('ar')->isoFormat('dddd, D MMMM YYYY h:mm A')); ?></td>
                    <td><?php echo e(number_format($order->total())); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>



<br><br><br>

        <!-- Show the Items Sold in this Shift -->
        <h4>الأصناف المباعة في هذه الوردية</h4>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>اسم المنتج</th>
                    <th>الكمية</th>
                    <th>إجمالي الإيرادات</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productName => $itemData): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($productName); ?></td>
                    <td><?php echo e($itemData['quantity']); ?></td>
                    <td><?php echo e(number_format($itemData['revenue'])); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
<br>
        <!-- Show the Total Revenue from this Shift -->
        <h4>إجمالي الإيرادات: <?php echo e(number_format($totalRevenue)); ?></h4>



<br><br><br>
        <!-- Show Expenses -->
        <h4>المصروفات في هذه الوردية</h4>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>اسم المصروف</th>
                    <th>قيمة المصروف</th>
                    <th>طريقة الدفع</th>
                    <th>تاريخ المصروف</th>
                    <th>ملاحظات</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $expenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $expense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($expense->expense_name); ?></td>
                    <td><?php echo e(number_format($expense->expense_price, 2)); ?></td>
                    <td><?php echo e($expense->payment_method); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($expense->expense_date)->locale('ar')->isoFormat('dddd, D MMMM YYYY h:mm A')); ?></td>
                    <td><?php echo e($expense->expense_note); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
<br>
        <!-- Show Total Expenses -->
        <h4>إجمالي المصروفات: <?php echo e(number_format($totalExpense, 2)); ?></h4>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\php\pear\~\resources\views/shifts/shift_report.blade.php ENDPATH**/ ?>