<?php $__env->startSection('title', 'العملاء والموردين'); ?>
<?php $__env->startSection('content-header', ''); ?>
<?php $__env->startSection('content-actions'); ?>
    <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-primary">اضافة عميل  جديد</a>
    <a href="<?php echo e(url('admin')); ?>/agsat" class="btn btn-primary"> عرض الأقساط  </a>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('plugins/sweetalert2/sweetalert2.min.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-body">
            <table class="table">
                <thead>
                <tr>
                    <th>ID</th>
                    <th>الاسم الاول</th>
                    <th>الاسم الاخير</th>
                    <th>البريد  الالكتروني</th>
                    <th>رقم الهاتف</th>
                    <th>العنوان </th>
                    <th>تاريخ الانشاء </th>
                    <th>الادارة</th>
                </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($customer->id); ?></td>
                        <td style="display: none;">
                            <img width="50" src="<?php echo e($customer->getAvatarUrl()); ?>" alt="">
                        </td>
                        <td><?php echo e($customer->first_name); ?></td>
                        <td><?php echo e($customer->last_name); ?></td>
                        <td><?php echo e($customer->email); ?></td>
                        <td><?php echo e($customer->phone); ?></td>
                        <td><?php echo e($customer->address); ?></td>
                        <td><?php echo e($customer->created_at); ?></td>
                        <td>

                        <a style="display:none" href="<?php echo e(url('admin/agsat/create/'.$customer->id)); ?>" class="btn btn-success">
                                اضافة أقساط 
                                    <i
                                    class="fas fa-plus"></i></a>

                            <a href="<?php echo e(route('customers.edit', $customer)); ?>" class="btn btn-primary"><i
                                    class="fas fa-edit"></i></a>

                            <?php if($customer->id > 4): ?>
                            <button class="btn btn-danger btn-delete" style="display:none" data-url="<?php echo e(route('customers.destroy', $customer)); ?>"><i
                                    class="fas fa-trash"></i></button>
                            <?php endif; ?>
                            
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <?php echo e($customers->render()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('plugins/sweetalert2/sweetalert2.min.js')); ?>"></script>
    <script>
        $(document).ready(function () {
            $(document).on('click', '.btn-delete', function () {
                $this = $(this);
                const swalWithBootstrapButtons = Swal.mixin({
                    customClass: {
                        confirmButton: 'btn btn-success',
                        cancelButton: 'btn btn-danger'
                    },
                    buttonsStyling: false
                })

                swalWithBootstrapButtons.fire({
                    title: 'Are you sure?',
                    text: "Do you really want to delete this customer?",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'Yes, delete it!',
                    cancelButtonText: 'No',
                    reverseButtons: true
                }).then((result) => {
                    if (result.value) {
                        $.post($this.data('url'), {_method: 'DELETE', _token: '<?php echo e(csrf_token()); ?>'}, function (res) {
                            $this.closest('tr').fadeOut(500, function () {
                                $(this).remove();
                            })
                        })
                    }
                })
            })
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\php\pear\~\resources\views/customers/index.blade.php ENDPATH**/ ?>