@extends('layouts.admin')

@section('content')
<div class="card">
    <div class="card-header">
        <h3 class="card-title">تفاصيل الوردية: {{ $shift->id }}</h3>
    </div>
    <div class="card-body">

        <!-- Show Shift Begin and End Dates and Times -->
        <h4>تاريخ ووقت بداية الوردية: {{ \Carbon\Carbon::parse($shift->shift_begin)->locale('ar')->isoFormat('dddd, D MMMM YYYY h:mm A') }}</h4>
        <h4 style="float:left">تاريخ ووقت نهاية الوردية: {{ $shift->shift_end ? \Carbon\Carbon::parse($shift->shift_end)->locale('ar')->isoFormat('dddd, D MMMM YYYY h:mm A') : 'لم تغلق بعد' }}</h4>


<br><br><br>

        <!-- Show the Orders (Tickets) -->
        <h4>التذاكر في هذه الوردية</h4>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>رقم الطلب</th>
                    <th>تاريخ الطلب</th>
                    <th>إجمالي الطلب</th>
                </tr>
            </thead>
            <tbody>
                @foreach($orders as $order)
                <tr>
                    <td><a href="#" onclick="window.open('{{ url('admin/ticket/' . $order->id) }}', '', 'width=400,height=500');">{{ $order->v_id }}</a></td>
                    <td>{{ $order->created_at->locale('ar')->isoFormat('dddd, D MMMM YYYY h:mm A') }}</td>
                    <td>{{ number_format($order->total()) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>



<br><br><br>

        <!-- Show the Items Sold in this Shift -->
        <h4>الأصناف المباعة في هذه الوردية</h4>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>اسم المنتج</th>
                    <th>الكمية</th>
                    <th>إجمالي الإيرادات</th>
                </tr>
            </thead>
            <tbody>
                @foreach($items as $productName => $itemData)
                <tr>
                    <td>{{ $productName }}</td>
                    <td>{{ $itemData['quantity'] }}</td>
                    <td>{{ number_format($itemData['revenue']) }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
<br>
        <!-- Show the Total Revenue from this Shift -->
        <h4>إجمالي الإيرادات: {{ number_format($totalRevenue) }}</h4>



<br><br><br>
        <!-- Show Expenses -->
        <h4>المصروفات في هذه الوردية</h4>
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>اسم المصروف</th>
                    <th>قيمة المصروف</th>
                    <th>طريقة الدفع</th>
                    <th>تاريخ المصروف</th>
                    <th>ملاحظات</th>
                </tr>
            </thead>
            <tbody>
                @foreach($expenses as $expense)
                <tr>
                    <td>{{ $expense->expense_name }}</td>
                    <td>{{ number_format($expense->expense_price, 2) }}</td>
                    <td>{{ $expense->payment_method }}</td>
                    <td>{{ \Carbon\Carbon::parse($expense->expense_date)->locale('ar')->isoFormat('dddd, D MMMM YYYY h:mm A') }}</td>
                    <td>{{ $expense->expense_note }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>
<br>
        <!-- Show Total Expenses -->
        <h4>إجمالي المصروفات: {{ number_format($totalExpense, 2) }}</h4>

    </div>
</div>
@endsection
