@extends('layouts.admin')

@section('title', 'صلاحية المنتجات')
@section('content-header', 'الصلاحية')
@section('content-actions')


                <?php 

/*
$expire_date = "18-10-2023";

$expire = strtotime($expire_date. ' - 2 months');

$today = strtotime("today midnight + 3months");


if($expire > $today){
    echo "Active";
} else {
    echo "Expired";
}
*/
                ?>

                <?php
                $today = strtotime("today midnight + 3months");

                $today = date("Y-m-d",$today);



                $order_items = App\Models\OrderItem::where('expire_status','not_checked')
                //->where('expire_date','<',$today)s
                ->where('type','purchase')
                ->OrderBy('expire_date','asc')
                ->get();

              //  dd($order_items);
                ?>


@endsection
@section('css')
<link rel="stylesheet" href="{{ asset('plugins/sweetalert2/sweetalert2.min.css') }}">
@endsection
@section('content')


<div class="card">
    <div class="card-body">
        <table class="table">
            <thead>

                                @if(Config::get('app.locale') == "ar")
                <tr>
                    <th>#</th>
                    <th>الاسم</th>
                    <th style="display: none;">الصورة</th>
                    <th style="display: none;">باركود</th>
                    <th>السعر</th>
                    <th>كمية الطلبية</th>
                    <th>فاتورة الشراء </th>

                    <!--
                    <th>الكمية المتبقية</th>
                    <th>الكمية المباعه</th>
                    <th>الربح</th> 
                    <th>الحالة</th> -->
                    <th>تاريخ  الشراء</th>
                    <th>تاريخ الانتهاء</th>
                    <th>Actions</th>
                </tr>

                                @else
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th style="display: none;">Image</th>
                    <th style="display: none;">Barcode</th>
                    <th>Price</th>
                    <th>Quantity</th>
                    <th>Sold</th>
                    <th>Profit</th>
                    <th>Status</th>
                    <th>Updated At</th>
                    <th>Actions</th>
                </tr>

                        @endif
            </thead>
            <tbody>

                <?php
                foreach($order_items as $r) {

                    $product = \App\Models\Product::where('id',$r->product_id)->first();
                
                
                ?>

                <tr>
                    <td>{{$product->id}}</td>
                    <td>{{$product->name}}</td>
                    <td style="display: none;"><img src="{{url('storage')}}/{{$product->image}}" alt="" width="100"></td>
                    <td style="display: none;">{{$product->barcode}}</td>
                    <td>{{$product->price}}</td>
                    <td>{{$r->quantity}}</td>
                    <td><a href="#" onclick="window.open('<?php echo url('admin/ticket/'); ?>/<?php echo $r->order_id; ?>','','width=400,height=500');">{{$r->order_id}}</a></td>
                 


                    <td>{{$r->created_at}}</td>
                    <td>{{$r->expire_date}}</td>

                    <td style="display: none;">
                    <?php 
                        $total_sold = 0;
                    $items = \App\Models\OrderItem::where('product_id',$product->id)
                    ->where('type','sale')
                    ->get('quantity');
                      
                        
                        foreach($items as $r2) {
                            $total_sold = $total_sold + $r2->quantity;
                        }

                        echo $total_sold;



                    ?>

                    </td>


                    <td style="display: none;">
                        {{($product->price - $product->buy_price) * $total_sold }}</td>


                    <td>

                   
                        <a onclick="return confirm('هل أنت متأكد من اجراء  هذه العملية ؟');" 
                        href="{{url('expire_checked')}}/{{$r->id}}">
                        <span class="right badge badge-success">
                            <i class="fa fa-check"></i> Checked</span>
                        </a>
                    </td>






                </tr>
                <?php } ?>
            </tbody>
        </table>
        {{ $products->render() }}
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('plugins/sweetalert2/sweetalert2.min.js') }}"></script>
<script>
    $(document).ready(function () {
        $(document).on('click', '.btn-delete', function () {
            $this = $(this);
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger'
                },
                buttonsStyling: false
                })

                swalWithBootstrapButtons.fire({
                title: 'Are you sure?',
                text: "Do you really want to delete this product?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'No',
                reverseButtons: true
                }).then((result) => {
                if (result.value) {
                    $.post($this.data('url'), {_method: 'DELETE', _token: '{{csrf_token()}}'}, function (res) {
                        $this.closest('tr').fadeOut(500, function () {
                            $(this).remove();
                        })
                    })
                }
            })
        })
    })
</script>
@endsection
