@extends('layouts.admin')

@section('title', 'Orders List')



 

@section('content-actions')
<a href="{{url('admin/new_purchase')}}" class="btn btn-primary"> عملية شراء جديدة </a>
@endsection

@section('content')


<?php
$bankak = 0;
$cash = 0;
$total_amount = 0;
$discount = 0;

$payments = \App\Models\Payment::where('type','purchase')->get();
?>

@foreach ($payments as $r)
    
    <?php

    $total_amount = $total_amount + $r->amount;
    $discount = $discount + $r->discount;

    ?>

@endforeach

<div class="row" style="text-align: center; display: none;">
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-danger">
              <div class="inner">
                <h3>{{config('settings.currency_symbol')}} {{number_format($bankak,0)}}</h3>

                <p> حساب بنكك
</p>
              </div>
              <div class="icon">
                <i class="ion ion-pie-graph"></i>
              </div>
             
            </div>
          </div>
          <!-- ./col -->

                    <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-success">
              <div class="inner">
                <h3>{{config('settings.currency_symbol')}} {{number_format($cash,0) }} </h3>

                <p> Cash | الكاش  </p>
              </div>
              <div class="icon">
                <i class="ion ion-pie-graph"></i>
              </div>
              
            </div>
          </div>
          <!-- ./col -->

      </div>


@if(Config::get('app.locale') == "ar")
        <?php
        if(isset($user_id)) { ?>
        <h3 style="text-align: center; direction: rtl;"> 
             تقرير المستخدم :
        <?php 
            echo \App\Models\User::where('id',$user_id)->first()->first_name." ";
            echo \App\Models\User::where('id',$user_id)->first()->last_name;
        ?>

        </h3>

       <?php      
        }
        ?>

@else
        <?php
        if(isset($user_id)) { ?>
        <h3> 
            User : 
        <?php 
            echo \App\Models\User::where('id',$user_id)->first()->first_name." ";
            echo \App\Models\User::where('id',$user_id)->first()->last_name;
        ?>

        </h3>

       <?php      
        }
        ?>

@endif

  
@if(Config::get('app.locale') == "ar")
  <h4 style="text-align: center;"> اجمالي المشتريات : {{ number_format($total_amount - $discount, 2) }} 


&nbsp;&nbsp; | &nbsp;&nbsp; <a href="{{url('admin/orders_by_customers_purchase')}}"> مطالبات الموردين  </a>


&nbsp;&nbsp; | &nbsp;&nbsp; <a href="{{url('products/all_expiry')}}"> مراجعة  الصلاحية</a>

  </h4>

@else
  <h4> Total Orders : {{ number_format($total_amount - $discount, 2) }} </h4>
@endif
<div class="card">
    <div class="card-body">
        <div class="row" style="display: none;">
            <div class="col-md-7"></div>
            <div class="col-md-5">
                <form action="{{route('orders.index')}}">
                    <div class="row">
                        <div class="col-md-5">
                            <input type="date" name="start_date" class="form-control" value="{{request('start_date')}}" />
                        </div>
                        <div class="col-md-5">
                            <input type="date" name="end_date" class="form-control" value="{{request('end_date')}}" />
                        </div>
                        <div class="col-md-2">
                            <button class="btn btn-outline-primary" type="submit">Submit</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <table class="table" >
            <thead>

@if(Config::get('app.locale') == "ar")
                <tr>
                    <th>#</th>
                    <th>اسم المورد</th>
                    <th>اسم البائع</th>
                    <th>اجمالي الفاتورة</th>
                    <th>الخصم </th>

                    <th>التاريخ</th>
                    <th><i class="fa fa-trash"></i></th>
                </tr>
@else
                <tr>
                    <th>ID</th>
                    <th>Customer Name</th>
                    <th>User</th>
                    <th>Total</th>
                    <th>Discount </th>
                    <th>Paid </th>
                    <th>Status</th>
                    <th>Created At</th>
                    <th><i class="fa fa-trash"></i></th>
                </tr>
@endif


            </thead>
            <tbody>
                <?php
                $the_total = 0;
                $the_discount = 0;
                $total_profit = 0;

                ?>
                @foreach ($orders as $order)
                <tr>
                    <td><a href="#" onclick="window.open('<?php echo url('admin/ticket/'); ?>/<?php echo $order->id; ?>','','width=400,height=500');">{{$order->id}}</a></td>
                    <td>{{$order->getCustomerName()}}</td>
                    <td>{{$order->user->first_name}} {{$order->user->last_name}} </td>
                    <td>{{ config('settings.currency_symbol') }} 

<?php $all_amount = \App\Models\Payment::where('order_id',$order->id)->first()->amount ?>
        {{$all_amount}}
                    </td>
                    <td>{{ config('settings.currency_symbol') }} {{$order->discount}}</td>
                  


<?php 
$bankak_paid = \App\Models\Payment::where('order_id',$order->id)->first()->bankak;
$cash_paid = \App\Models\Payment::where('order_id',$order->id)->first()->cash;

$total_paid = $bankak_paid + $cash_paid;

?>

                    
        <?php /*

                    <td>
                        @if($total_paid == 0)
                            <span class="badge badge-danger">Not Paid</span>
                        @elseif($total_paid < $all_amount)
                            <span class="badge badge-warning">Partial</span>
                        @elseif($total_paid == $all_amount)
                            <span class="badge badge-success">Paid</span>
                        @elseif($total_paid > $all_amount)
                            <span class="badge badge-info">Change</span>
                        @endif
                    </td>
                    */ ?>

                    <td>{{$order->created_at}}</td>
                    <td> 


		
      @if(auth()->user()->id  == '4') 
                            <span class="btn btn-danger btn-sm" >
                                <form action="{{url('/admin/orders/')}}/{{ $order->id }}" method="post">
                                    @method('DELETE')
                                    <button onclick="return confirm('Are you sure you want to delete this ?');" style="border: 0px; background:none; color: white">
                                        <i class="fas fa-trash"></i>
                                        Delete</button>
                                    @csrf
                                </form>


                            </span>
                       @endif 

                    </td>
                </tr>

                <?php 
                $the_total = $the_total + $order->total_purchases();
                $the_discount = $the_discount + $order->discount;
                $total_profit = $total_profit + $order->net_profit;
                ?>
                @endforeach
            </tbody>
            <tfoot>
                <tr>
                    <th></th>
                    <th></th>
                    <th></th>

                    <?php /*
                    <th>{{ config('settings.currency_symbol') }} {{ number_format($total, 2) }}</th>
                    <th>{{ config('settings.currency_symbol') }} {{ number_format($the_discount, 2) }}</th>
                    
                    <th>{{ config('settings.currency_symbol') }} {{ number_format($the_total - $the_discount, 2) }}</th> */?>


                    <th></th>
                    <th></th>
                    <th></th>
                </tr>
            </tfoot>
        </table>
        {{ $orders->render() }}
    </div>
</div>
@endsection

