@extends('layouts.admin')

@section('title', 'Management System')

@section('content')




    <div class="container-fluid" style="direction: rtl; text-align: center; min-height: 500px;">

        <div class="row">

          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-info">
              <div class="inner">
                  <h3>{{$orders_count}}</h3>
                <p>{{__('Orders Count')}}</p>
              </div>
              <div class="icon">
                <i class="ion ion-bag"></i>
              </div>
              <a href="{{route('orders.index')}}" class="small-box-footer">{{__('More info')}} <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-success">
              <div class="inner">
                  <h3>{{config('settings.currency_symbol')}} 

                    <?php
                    $net_p = 0;

                    $orders1 = \App\Models\Order::where('order_status','active')
                    ->where('type','sale')
                    ->where('status','done')
                    ->where('created_at','>=', date('Y-m-d').' 00:00:00')
                    ->get();

                    $today_orders = \App\Models\Order::where('order_status','active')
                    ->where('type','sale')
                    //->where('status','done')
                    ->where('created_at','>=', date('Y-m-d').' 00:00:00')
                    ->count();

                    foreach($orders1 as $r) {
                      $net_p = $net_p + $r->net_profit;
                    }

                    echo number_format($net_p,0);

                    ?>

                  </h3>
                <p>
                  أرباح اليوم
                </p>
              </div>
              <div class="icon">
                <i class="ion ion-stats-bars"></i>
              </div>
              <a href="{{route('orders.index')}}" class="small-box-footer">{{__('More info')}} <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-success">
              <div class="inner">
                <h3>{{config('settings.currency_symbol')}} {{number_format($income_today, 2)}}</h3>

                <p>
                  {{__('Income Today')}}
</p>
              </div>
              <div class="icon">
                <i class="ion ion-pie-graph"></i>
              </div>
              <a href="{{route('orders.index')}}" class="small-box-footer">{{__('More info')}} <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-warning">
              <div class="inner">
                <h3>{{ $today_orders }}</h3>

                <p> مبيعات اليوم
</p>
              </div>
              <div class="icon">
                <i class="ion ion-person-add"></i>
              </div>
              <a href="{{ route('customers.index') }}" class="small-box-footer">{{__('More info')}} <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->



          <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-danger">
              <div class="inner">
                <h3>



                    <?php
                    $today_expenses = 0;

                    $expenses = \App\expenses::
                    where('created_at','>=', date('Y-m-d').' 00:00:00')
                    ->get();

                    foreach($expenses as $r) {
                      $today_expenses = $today_expenses + $r->expense_price;
                    }

                    echo number_format($today_expenses,0);

                    ?>


                 </h3>

                <p> منصرفات اليوم 
</p>
              </div>
              <div class="icon">
                <i class="ion ion-person-add"></i>
              </div>
              <a href="{{ route('customers.index') }}" class="small-box-footer">{{__('More info')}} <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->


                    <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-danger">
              <div class="inner">
                <h3>
                  


                    <?php
                    $all_expenses = 0;

                    $expenses = \App\expenses::get();

                    foreach($expenses as $r) {
                      $all_expenses = $all_expenses + $r->expense_price;
                    }

                    echo number_format($all_expenses,0);

                    ?>



                </h3>

                <p> اجمالي المنصرفات 
</p>
              </div>
              <div class="icon">
                <i class="ion ion-person-add"></i>
              </div>
              <a href="{{ route('customers.index') }}" class="small-box-footer">{{__('More info')}} <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->




                    <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-danger">
              <div class="inner">
                <h3>



                    <?php
                    $remaining = 0;
                    $customer_paid = 0;

                    $customers = \App\Models\Customer::where('id','<>','4')
                    ->where('type','sale')
                    ->get();

                    foreach($customers as $customer) {
                      $orders = \App\Models\Order::where('customer_id',$customer->id)
                      ->where('order_status','active')
                      ->where('type','sale')
                      ->where('status','not_done')
                      ->get();

                      $customer_paid = $customer_paid + $customer->paid;

                    //  dd($orders);

                      foreach($orders as $order){
                        $payment = \App\Models\Payment::where('order_id',$order->id)->first();
                        $remaining = $remaining + $payment->amount;

                      }


                    }
                   // dd($customer_paid);
                    echo number_format($remaining - $customer_paid,0);

                    ?>


                 </h3>

                <p> اجمالي الدليفري
</p>
              </div>
              <div class="icon">
                <i class="ion ion-person-add"></i>
              </div>
              <a href="{{ route('customers.index') }}" class="small-box-footer">{{__('More info')}} <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->




         <!-- ./col -->
          <div class="col-lg-3 col-6">
            <!-- small box -->
            <div class="small-box bg-danger">
              <div class="inner">
                <h3>



                    <?php
                    $new_remain = 0;
                    $customer_paid = 0;

                    $customers = \App\Models\Customer::where('id','<>','4')
                    ->where('type','sale')
                    ->where('updated_at','>=', date('Y-m-d').' 00:00:00')
                    ->get();

                    foreach($customers as $customer) {
                      $orders = \App\Models\Order::where('customer_id',$customer->id)
                      ->where('order_status','active')
                      ->where('type','sale')
                      ->where('status','not_done')
                       ->where('created_at','>=', date('Y-m-d').' 00:00:00')
                      ->get();


                      $customer_paid = $customer_paid + $customer->paid;

                    //  dd($ordremain = $new_remain + $payment->amount;
                        
                      


                    }

                    if($new_remain - $customer_paid > 0){
                    echo number_format($new_remain - $customer_paid,0);
                    }

                    else {
                      echo 0;
                    }
                    ?>


                 </h3>

                <p> دليفري اليوم
</p>
              </div>
              <div class="icon">
                <i class="ion ion-person-add"></i>
              </div>
              <a href="{{ route('customers.index') }}" class="small-box-footer">{{__('More info')}} <i class="fas fa-arrow-circle-right"></i></a>
            </div>
          </div>
          <!-- ./col -->




    </div>




    <div class="row ">

      <div class="col-md-12">
        
        <div class="card bg-gradient-success">
<div class="card-header border-0 ui-sortable-handle" style="cursor: move;">
<h3 class="card-title">
<i class="far fa-calendar-alt"></i>
Calendar
</h3>

<div class="card-tools">

<div class="btn-group">
<button type="button" class="btn btn-success btn-sm dropdown-toggle" data-toggle="dropdown" data-offset="-52">
<i class="fas fa-bars"></i>
</button>
<div class="dropdown-menu" role="menu">
<a href="#" class="dropdown-item">Add new event</a>
<a href="#" class="dropdown-item">Clear events</a>
<div class="dropdown-divider"></div>
<a href="#" class="dropdown-item">View calendar</a>
</div>
</div>
<button type="button" class="btn btn-success btn-sm" data-card-widget="collapse">
<i class="fas fa-minus"></i>
</button>
<button type="button" class="btn btn-success btn-sm" data-card-widget="remove">
<i class="fas fa-times"></i>
</button>
</div>

</div>

<div class="card-body pt-0">

<div id="calendar" style="width: 100%; direction: rtl;"><div class="bootstrap-datetimepicker-widget usetwentyfour"><ul class="list-unstyled"><li class="show"><div class="datepicker"><div class="datepicker-days" style=""><table class="table table-sm"><thead><tr><th class="prev" data-action="previous"><span class="fa fa-chevron-left" title="Previous Month"></span></th><th class="picker-switch" data-action="pickerSwitch" colspan="5" title="Select Month"><?php echo date("M Y"); ?></th>
<!--
  <th class="next" data-action="next"><span class="fa fa-chevron-right" title="Next Month"></span></th></tr><tr><th class="dow">Su</th><th class="dow">Mo</th><th class="dow">Tu</th><th class="dow">We</th><th class="dow">Th</th><th class="dow">Fr</th><th class="dow">Sa</th></tr></thead>

-->

  <tbody><tr><td data-action="selectDay" data-day="01/01/2023" class="day weekend">1</td><td data-action="selectDay" data-day="01/02/2023" class="day">2</td><td data-action="selectDay" data-day="01/03/2023" class="day">3</td><td data-action="selectDay" data-day="01/04/2023" class="day">4</td><td data-action="selectDay" data-day="01/05/2023" class="day">5</td><td data-action="selectDay" data-day="01/06/2023" class="day">6</td><td data-action="selectDay" data-day="01/07/2023" class="day weekend">7</td></tr><tr><td data-action="selectDay" data-day="01/08/2023" class="day weekend">8</td><td data-action="selectDay" data-day="01/09/2023" class="day">9</td><td data-action="selectDay" data-day="01/10/2023" class="day">10</td><td data-action="selectDay" data-day="01/11/2023" class="day">11</td><td data-action="selectDay" data-day="01/12/2023" class="day">12</td><td data-action="selectDay" data-day="01/13/2023" class="day">13</td><td data-action="selectDay" data-day="01/14/2023" class="day weekend">14</td></tr><tr><td data-action="selectDay" data-day="01/15/2023" class="day weekend">15</td><td data-action="selectDay" data-day="01/16/2023" class="day">16</td><td data-action="selectDay" data-day="01/17/2023" class="day">17</td><td data-action="selectDay" data-day="01/18/2023" class="day">18</td><td data-action="selectDay" data-day="01/19/2023" class="day">19</td><td data-action="selectDay" data-day="01/20/2023" class="day">20</td><td data-action="selectDay" data-day="01/21/2023" class="day weekend">21</td></tr><tr><td data-action="selectDay" data-day="01/22/2023" class="day active today weekend">{{date('d')}}</td><td data-action="selectDay" data-day="01/23/2023" class="day">23</td><td data-action="selectDay" data-day="01/24/2023" class="day">24</td><td data-action="selectDay" data-day="01/25/2023" class="day">25</td><td data-action="selectDay" data-day="01/26/2023" class="day">26</td><td data-action="selectDay" data-day="01/27/2023" class="day">27</td><td data-action="selectDay" data-day="01/28/2023" class="day weekend">28</td></tr><tr><td data-action="selectDay" data-day="01/29/2023" class="day weekend">29</td><td data-action="selectDay" data-day="01/30/2023" class="day">30</td><td data-action="selectDay" data-day="01/31/2023" class="day">31</td><td data-action="selectDay" data-day="02/01/2023" class="day new">1</td><td data-action="selectDay" data-day="02/02/2023" class="day new">2</td><td data-action="selectDay" data-day="02/03/2023" class="day new">3</td><td data-action="selectDay" data-day="02/04/2023" class="day new weekend">4</td></tr><tr><td data-action="selectDay" data-day="02/05/2023" class="day new weekend">5</td><td data-action="selectDay" data-day="02/06/2023" class="day new">6</td><td data-action="selectDay" data-day="02/07/2023" class="day new">7</td><td data-action="selectDay" data-day="02/08/2023" class="day new">8</td><td data-action="selectDay" data-day="02/09/2023" class="day new">9</td><td data-action="selectDay" data-day="02/10/2023" class="day new">10</td><td data-action="selectDay" data-day="02/11/2023" class="day new weekend">11</td></tr></tbody></table></div><div class="datepicker-months" style="display: none;"><table class="table-condensed"><thead><tr><th class="prev" data-action="previous"><span class="fa fa-chevron-left" title="Previous Year"></span></th><th class="picker-switch" data-action="pickerSwitch" colspan="5" title="Select Year">2023</th><th class="next" data-action="next"><span class="fa fa-chevron-right" title="Next Year"></span></th></tr></thead><tbody><tr><td colspan="7"><span data-action="selectMonth" class="month active">Jan</span><span data-action="selectMonth" class="month">Feb</span><span data-action="selectMonth" class="month">Mar</span><span data-action="selectMonth" class="month">Apr</span><span data-action="selectMonth" class="month">May</span><span data-action="selectMonth" class="month">Jun</span><span data-action="selectMonth" class="month">Jul</span><span data-action="selectMonth" class="month">Aug</span><span data-action="selectMonth" class="month">Sep</span><span data-action="selectMonth" class="month">Oct</span><span data-action="selectMonth" class="month">Nov</span><span data-action="selectMonth" class="month">Dec</span></td></tr></tbody></table></div><div class="datepicker-years" style="display: none;"><table class="table-condensed"><thead><tr><th class="prev" data-action="previous"><span class="fa fa-chevron-left" title="Previous Decade"></span></th><th class="picker-switch" data-action="pickerSwitch" colspan="5" title="Select Decade">2020-2029</th><th class="next" data-action="next"><span class="fa fa-chevron-right" title="Next Decade"></span></th></tr></thead><tbody><tr><td colspan="7"><span data-action="selectYear" class="year old">2019</span><span data-action="selectYear" class="year">2020</span><span data-action="selectYear" class="year">2021</span><span data-action="selectYear" class="year">2022</span><span data-action="selectYear" class="year active">2023</span><span data-action="selectYear" class="year">2024</span><span data-action="selectYear" class="year">2025</span><span data-action="selectYear" class="year">2026</span><span data-action="selectYear" class="year">2027</span><span data-action="selectYear" class="year">2028</span><span data-action="selectYear" class="year">2029</span><span data-action="selectYear" class="year old">2030</span></td></tr></tbody></table></div><div class="datepicker-decades" style="display: none;"><table class="table-condensed"><thead><tr><th class="prev" data-action="previous"><span class="fa fa-chevron-left" title="Previous Century"></span></th><th class="picker-switch" data-action="pickerSwitch" colspan="5">2000-2090</th><th class="next" data-action="next"><span class="fa fa-chevron-right" title="Next Century"></span></th></tr></thead><tbody><tr><td colspan="7"><span data-action="selectDecade" class="decade old" data-selection="2006">1990</span><span data-action="selectDecade" class="decade" data-selection="2006">2000</span><span data-action="selectDecade" class="decade" data-selection="2016">2010</span><span data-action="selectDecade" class="decade active" data-selection="2026">2020</span><span data-action="selectDecade" class="decade" data-selection="2036">2030</span><span data-action="selectDecade" class="decade" data-selection="2046">2040</span><span data-action="selectDecade" class="decade" data-selection="2056">2050</span><span data-action="selectDecade" class="decade" data-selection="2066">2060</span><span data-action="selectDecade" class="decade" data-selection="2076">2070</span><span data-action="selectDecade" class="decade" data-selection="2086">2080</span><span data-action="selectDecade" class="decade" data-selection="2096">2090</span><span data-action="selectDecade" class="decade old" data-selection="2106">2100</span></td></tr></tbody></table></div></div></li><li class="picker-switch accordion-toggle"></li></ul></div></div>
</div>

</div>

      </div>
      
      
    </div>





</div>
@endsection
