@extends('layouts.admin')

@section('content')



    <div class="card">
        <div class="card-header">
           <center> <h1>تقرير منصرفات شهر {{ Request::segment(4) }}</h1> </center>
            
           <br>

<?php 
   $month = \Carbon\Carbon::now()->month;
   $year = \Carbon\Carbon::now()->year;

$products = \App\expense_types::whereYear('created_at', '=', $year)
              ->whereMonth('created_at', '=', Request::segment(4))
              ->get();
?>

        <div class="row">
@foreach($products as $r)
        <!-- ./col -->
        <div class="col-lg-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-red">
            <div class="inner" style="text-align: center;">
              <h3>
                <?php
                  $s_accounts = \App\expenses::where('expense_id',$r->id)->get();
                  $total_amount = 0;    

                  foreach($s_accounts as $r2)  {
                    $total_amount = $total_amount + $r2->expense_price;
                  }

                  echo number_format($total_amount);

                ?>
              </h3>

              <p><a href="{{url('admin/expenses/')}}/{{$r->id}}" style="text-decoration: none; color: white; cursor: pointer;">اجمالي {{$r->title}}</a></p>
            </div>
            <div class="icon">
              <i class="ion ion-stats-bars"></i>
            </div>
          </div>
        </div>

@endforeach
        </div> <!-- End of Row -->


        </div>

       




        <!-- /.card-header -->
        <div class="card-body">
            <table id="example1" class="table table-bordered table-striped" style="">
                <thead>
                <tr>

                    <th>#</th>
                    <th>التاريخ</th>
                    <th>اسم المنصرف</th>
                    <th>قيمة المنصرف</th>
                    <th>ملاحظات</th>
                    <th>تفاصيل</th>
                    <th>تعديل</th>
                    <th>حذف</th>
                </tr>
                </thead>
                <tbody>

<?php 
$expenses = \App\expenses::whereYear('created_at', '=', $year)
              ->whereMonth('created_at', '=', Request::segment(4))
              ->get();
?>
@forelse($expenses as $expense)

                <tr>
                    <td> {{ $expense->id }}</td>
                    <td> {{ $expense->created_at->format('Y-m-d') }} </td>
                    <td>
                        <a href="{{url('admin/expenses/')}}/{{$expense->expense_type->id}}"> {{ $expense->expense_type->title }} 
                       </a>
                    </td>
                    <td> {{ number_format($expense->expense_price) }} </td>
                    <td> {{ $expense->expense_note }} </td>


                    <td>
                        <a class="btn btn-info btn-sm" href="/admin/expenses/{{$expense->id}}/edit">
                            <i class="fas fa-pencil-alt">
                            </i>
                            Edit
                        </a>
                    </td>

                    <td>
                        
                            <span class="btn btn-danger btn-sm" >
                                <form action="/admin/expenses/{{ $expense->id }}" method="post">
                                    @method('DELETE')
                                    <button onclick="return confirm('Are you sure you want to delete this ?');" style="border: 0px; background:none; color: white">
                                        <i class="fas fa-trash"></i>
                                        Delete</button>
                                    @csrf
                                </form>


                            </span>
                        
                    </td>
                </tr>

    @empty

    <tr>
       <div style="color: red; font-size: 18px; font-weight: bolder;">No Data Available</div>
    </tr>

                @endforelse










                </tbody>

            </table>
        </div>
        <!-- /.card-body -->
    </div>




@endsection
