@extends('layouts.admin')

@section('content')



    <div class="card">
        <div class="card-header">
            <h3 class="card-title"><?php //List of expenses ?></h3>
            <br>



<?php 
$expense_id = Request::segment(3);

?>

        <div class="row">
        <!-- ./col -->
        <div class="col-lg-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-red">
            <div class="inner" style="text-align: center;">
              <h3>
                <?php
                  $s_accounts = \App\expenses::where('expense_id',$expense_id)->get();
                  $total_amount = 0;    

                  foreach($s_accounts as $r2)  {
                    $total_amount = $total_amount + $r2->expense_price;
                  }

                  echo number_format($total_amount);

                ?>
              </h3>

              <p>اجمالي {{ \App\expense_types::where('id',$expense_id)->first()->title}}</p>
            </div>
            <div class="icon">
              <i class="ion ion-stats-bars"></i>
            </div>
          </div>
        </div>

        </div> <!-- End of Row -->


        </div>

       




        <!-- /.card-header -->
        <div class="card-body">
            <table id="example1" class="table table-bordered table-striped" style="">
                <thead>
                <tr>

                    <th>#</th>
                    <th>التاريخ</th>
                    <th>اسم المنصرف</th>
                    <th>قيمة المنصرف</th>
                    <th>ملاحظات</th>
                    <th>تعديل</th>
                    <th>حذف</th>
                </tr>
                </thead>
                <tbody>

<?php 
$expenses = \App\expenses::where('expense_id',$expense_id)->get();
?>

@forelse($expenses as $expense)

                <tr>
                    <td> {{ $expense->id }}</td>
                    <td> {{ $expense->created_at->format('Y-m-d') }} </td>
                    <td> {{ $expense->expense_type->title }} </td>
                    <td> {{ number_format($expense->expense_price) }} </td>
                    <td> {{ $expense->expense_note }} </td>

                    <td>
                        <a class="btn btn-info btn-sm" href="/admin/expenses/{{$expense->id}}/edit">
                            <i class="fas fa-pencil-alt">
                            </i>
                            Edit
                        </a>
                    </td>

                    <td>
                        
                            <span class="btn btn-danger btn-sm" >
                                <form action="/admin/expenses/{{ $expense->id }}" method="post">
                                    @method('DELETE')
                                    <button onclick="return confirm('Are you sure you want to delete this ?');" style="border: 0px; background:none; color: white">
                                        <i class="fas fa-trash"></i>
                                        Delete</button>
                                    @csrf
                                </form>


                            </span>
                        
                    </td>
                </tr>

    @empty

    <tr>
       <div style="color: red; font-size: 18px; font-weight: bolder;">No Data Available</div>
    </tr>

                @endforelse










                </tbody>

            </table>
        </div>
        <!-- /.card-body -->
    </div>




@endsection
