@extends('layouts.admin')

@section('content')



    <div class="card">
        <div class="card-header">
            <h3 class="card-title">تقرير المنصرفات </h3>
            <br>


        <div class="row">
        <!-- ./col -->
        <div class="col-lg-3 col-xs-6">
          <!-- small box -->
          <div class="small-box bg-red">
            <div class="inner" style="text-align: center;">
              <h3>
                <?php 
                  echo number_format($total);

                ?>
              </h3>

              <p><a href="" style="text-decoration: none; color: white; cursor: pointer;">اجمالي </a></p>
            </div>
            <div class="icon">
              <i class="ion ion-stats-bars"></i>
            </div>
          </div>
        </div>





         <form action="{{url('/admin/get_expense_report')}}" method="post" enctype="multipart/form-data">
                            @csrf
            

                      <div class="form-group">
                            <label for="date_from"> التاريخ من  </label>
                            <input type="date" name="date_from" id="date_from" class="form-control" id="date_from" placeholder="Enter date_from">
                            @error('date_from') {{ $message }} @enderror

                        </div>


                        <div class="form-group">
                            <label for="date_to"> التاريخ  الى  </label>
                            <input type="date" name="date_to" id="date_to" class="form-control" id="date_to" placeholder="Enter date_to">
                            @error('date_to') {{ $message }} @enderror

                        </div>

                     

                     

                        <div class="card-footer">
                        <button class="btn btn-primary" >عرض التقرير</button>
                       

                        </div>


                        </form>







        </div> <!-- End of Row -->


        </div>

       

        <!-- /.card-header -->
        <div class="card-body">
            <table id="example1" class="table table-bordered table-striped" style="">
                <thead>
                <tr>

                    <th>#</th>
                    <th>التاريخ</th>
                    <th>اسم المنصرف</th>
                    <th>قيمة المنصرف</th>
                    <th>ملاحظات</th>
                    <th>تعديل</th>
                    <th>حذف</th>
                </tr>
                </thead>
                <tbody>

@forelse($expenses as $expense)

                <tr>
                    <td> {{ $expense->id }}</td>
                    <td> {{ $expense->expense_date }} </td>
                    <td> {{ $expense->expense_name}}  </td>
                    <td> {{ number_format($expense->expense_price) }} </td>
                    <td> {{ $expense->expense_note }} </td>


                    <td>
                        <a class="btn btn-info btn-sm" href="{{url('/admin/expenses')}}/{{$expense->id}}/edit">
                            <i class="fas fa-pencil-alt">
                            </i>
                            Edit
                        </a>
                    </td>

                    <td>
                        
                            <span class="btn btn-danger btn-sm" >
                                <form action="{{url('/admin/expenses')}}/{{ $expense->id }}" method="post">
                                    @method('DELETE')
                                    <button onclick="return confirm('Are you sure you want to delete this ?');" style="border: 0px; background:none; color: white">
                                        <i class="fas fa-trash"></i>
                                        Delete</button>
                                    @csrf
                                </form>


                            </span>
                        
                    </td>
                </tr>

    @empty

    <tr>
       <div style="color: red; font-size: 18px; font-weight: bolder;">No Data Available</div>
    </tr>

                @endforelse










                </tbody>

            </table>
        </div>
        <!-- /.card-body -->
    </div>




@endsection
