@extends('layouts.admin')

@section('content')




        <!-- Content Wrapper. Contains categories content -->
        <div class="content-wrapper" style="margin-left:10px !important;">
            <!-- Content Header (categories header) -->
            <section class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1>تعديل قسم </h1>
                        </div>
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                                <li class="breadcrumb-item"><a href="#">الرئيسية</a></li>
                                <li class="breadcrumb-item active">CMS</li>
                            </ol>
                        </div>
                    </div>
                </div><!-- /.container-fluid -->
            </section>









            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-md-12">
                        <div class="success">
                            @if(session()->has('success'))
                                <div class="alert alert-success">
                                    {{ session()->get('success') }}
                                </div>
                            @endif


                        </div>
                        <form action="{{url('/admin/categories/')}}/{{ $categories->id }}" method="post" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                        <div class="form-group">
                            <label for="title">عنوان القسم</label>
                            <input type="title" name="title" value="{{$categories->title}}" class="form-control" id="title" placeholder="Enter title">
                            @error('title') {{ $message }} @enderror

                        </div>

                        <div class="form-group">
                            <label for="img"> الصورة</label>
                            <div class="input-group">
                                <div class="custom-file">
                                    <input type="file" name="img" id="img" >
                                    <label class="custom-file-label" for="img">اختر الصورة</label>
                                </div>

                                @error('img') {{ $message }} @enderror

                            </div>
                        </div>




                        <div class="card-footer">
                        <button class="btn btn-primary">تعديل القسم</button>
                        </div>


                        </form>


                    </div>
                    <!-- /.col-->
                </div>
                <!-- ./row -->
            </section>
            <!-- /.content -->
        </div>
        <!-- /.content-wrapper -->





@endsection
