<?php

namespace App\Http\Controllers;

use App\Http\Requests\CustomerStoreRequest;
use App\Models\Customer;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\transactions;
use App\banks;

class CustomerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response

     */

    public function index_purchases()
    {
        if (request()->wantsJson()) {
            return response(
                Customer::all()
            );
        }
        $customers = Customer::where('type','purchases')->latest()->paginate(10);
        return view('customers.index')->with('customers', $customers);
    }


    public function index()
    {
        if (request()->wantsJson()) {
            return response(
                Customer::all()
            );
        }
        $customers = Customer::where('type','sale')->latest()->paginate(10000);
        return view('customers.index')->with('customers', $customers);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('customers.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */


    public function paid() {

        $id = request()->id;

        $amount = request()->paid;
        $method = request()->payment_method;
        $notes = request()->notes;


        $customers_payments = new \App\customers_payments;
        $customers_payments->customer_id = $id;
        $customers_payments->payment_method = $method;
        $customers_payments->amount = $amount;
        $customers_payments->notes = $notes;
        $customers_payments->save();

////////////////////////////////////////////////

        $customer = Customer::find($id);

        $customer->paid = $customer->paid + request()->paid;
        $customer->save();

///////////////////////////////////////////////////

        if($customer->type == "sale") {
        $type = "credit";
        }

        if($customer->type == "purchases") {
        $type = "depit";
        }

        $trans = new transactions;
        $trans->type = $type;
        $trans->amount = $amount;
        $trans->payment_method = $method;

        if($customer->type == "sale") {
        $trans->notes = "مبيعات   - دفع مديونية  العميل  :".$customer->first_name." ".$customer->last_name.$notes;
        }

        if($customer->type == "purchases") {
        $trans->notes = "مشتريات - دفع  مشتريات   المورد   :".$customer->first_name." ".$customer->last_name.$notes;
        }

        $trans->trans_type = "customers";
        $trans->trans_type_id = $id;
        $trans->save();

        $banks = banks::where('id','1')->first();

        if($type == "credit") {
        $banks->balance = $banks->balance + $amount;
        }
        if($type == "depit") {
        $banks->balance = $banks->balance - $amount;
        }

        $banks->update();












        /*
        if($method == "bankak") {
            $order = \App\Models\Order::where('customer_id',$id)
            ->where('status','not_done')->first();


            $payments = \App\Models\Payment::where('order_id',$order->id)
            ->where('amount','>=','bankak + cash + shake')
            ->first();
            

            $payments->bankak = $payments->bankak + $amount;
            $payments->update();            

            if($payments->bankak + $payments->cash + $payments->shake >= $payments->amount)
            {
              //  $order->status = "done";
               // $order->update();
            }


        }





        if($method == "cash") {
        
                    $order = \App\Models\Order::where('customer_id',$id)
            ->where('status','not_done')->first();


            $payments = \App\Models\Payment::where('order_id',$order->id)
            ->where('amount','>','bankak + cash + shake')
            ->first();
            
            $payments->cash = $payments->cash + $amount;
            $payments->update();            

            if($payments->bankak + $payments->cash + $payments->shake >= $amount)
            {
              //  $order->status = "done";
                //$order->update();
            }
    

        }




        if($method == "shake") {
                        $order = \App\Models\Order::where('customer_id',$id)
            ->where('status','not_done')->first();


            $payments = \App\Models\Payment::where('order_id',$order->id)
            ->where('amount','>','bankak + cash + shake')
            ->first();
            
            $payments->shake = $payments->shake + $amount;
            $payments->update();            

            if($payments->bankak + $payments->cash + $payments->shake >= $amount)
            {
              //  $order->status = "done";
              //  $order->update();
            }

        } */


        return redirect()->back();


    }


    public function store(CustomerStoreRequest $request)
    {
        $avatar_path = '';

        if ($request->hasFile('avatar')) {
            $avatar_path = $request->file('avatar')->store('customers');
        }

        $customer = Customer::create([
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email,
            'phone' => $request->phone,
            'address' => $request->address,
            'type' => $request->type,
            'avatar' => $avatar_path,
            'user_id' => $request->user()->id,
        ]);

        if (!$customer) {
            return redirect()->back()->with('error', 'Sorry, there\'re a problem while creating customer.');
        }
        return redirect()->route('customers.index')->with('success', 'Success, your customer have been created.');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Customer  $customer
     * @return \Illuminate\Http\Response
     */
    public function show(Customer $customer)
    {
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Customer  $customer
     * @return \Illuminate\Http\Response
     */
    public function edit(Customer $customer)
    {
        return view('customers.edit', compact('customer'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Customer  $customer
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Customer $customer)
    {
        $customer->first_name = $request->first_name;
        $customer->last_name = $request->last_name;
        $customer->email = $request->email;
        $customer->phone = $request->phone;
        $customer->address = $request->address;
        $customer->type = $request->type;

        if ($request->hasFile('avatar')) {
            // Delete old avatar
            if ($customer->avatar) {
                Storage::delete($customer->avatar);
            }
            // Store avatar
            $avatar_path = $request->file('avatar')->store('customers');
            // Save to Database
            $customer->avatar = $avatar_path;
        }

        if (!$customer->save()) {
            return redirect()->back()->with('error', 'Sorry, there\'re a problem while updating customer.');
        }
        return redirect()->route('customers.index')->with('success', 'Success, your customer have been updated.');
    }

    public function destroy(Customer $customer)
    {
        if ($customer->avatar) {
            Storage::delete($customer->avatar);
        }

        $customer->delete();

       return response()->json([
           'success' => true
       ]);
    }
}
