<?php

use App\Http\Controllers\CartController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\CategoriesController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\SettingController;
use Illuminate\Support\Facades\Route;

use App\Http\Controllers\ExpensesController;
use App\Http\Controllers\ExpenseTypeController;
use App\Http\Controllers\PurchasesController;
use App\Http\Controllers\ShakesController;
use App\Http\Controllers\UnitsController;
use App\Http\Controllers\BanksController;
use App\Http\Controllers\AgsatController;




Route::get('/', function () {
    return redirect('/admin');
});

Auth::routes();

Route::get('lang/{locale}',function($lang){
       \Session::put('lang',$lang);
       return redirect()->back();   
});



Route::middleware('auth')->group(function () {

Route::get('/admin/shifts/{shiftId}/report', [OrderController::class, 'showShiftReport']);

    Route::view('/admin/shifts/shifts', 'shifts/shifts');

    Route::post('/admin/shift/close',[OrderController::class, 'close_shift']);
    Route::post('/admin/shift/begin',[OrderController::class, 'begin_shift']);


    Route::delete('/admin/orders/{order_id}',[OrderController::class, 'destroy']);

    Route::get('/admin/orders_purchases',[OrderController::class, 'index_purchase']);


    Route::get('/products/expired',[ProductController::class, 'index_expired']);
    Route::get('/products/all_expiry',[ProductController::class, 'all_expiry']);


    Route::post('/update_prices',[ProductController::class, 'update_prices']);
    Route::view('/update_prices','products.percent');


    Route::view('/customer_payments/{customer_id}','/orders/customer_payments');


    Route::view('/customers/paid/{customer_id}','/customers/paid');
    Route::post('/customers/paid',[CustomerController::class, 'paid']);

    Route::get('/search_by_client/{client_name}',[OrderController::class, 'search_by_client']);




    Route::get('/done_pay/{customer_id}',[OrderController::class, 'done_pay_customer']);
    Route::get('/expire_checked/{id}',[OrderController::class, 'expire_checked']);

    Route::get('/refund/{invoice_id}',[OrderController::class, 'refund']);
    Route::get('/invoice_edit/{invoice_id}',[OrderController::class, 'invoice_edit']);


    Route::view('/admin/pos','cart/index2');
    Route::view('/admin/pos/{invoice_id}/{customer_id}','cart/index2');
    Route::view('/admin/new_purchase','cart_purchases/index2');

    Route::get('/all_items/{id}',[CartController::class, 'all_items']);
    Route::get('/new_to_cart/{id}/{quantity}/{unit_id}/{product_id}',[CartController::class, 'new_to_cart']);
    Route::get('/delete_from_cart/{id}',[CartController::class, 'delete_from_cart']);
    Route::get('/delete_all_cart/',[CartController::class, 'delete_all_cart']);

    Route::get('/get_cart/',[CartController::class, 'get_cart']);

    Route::get('/change_price/{id}/{price}',[CartController::class, 'change_price']);
    Route::get('/change_unit/{id}/{unit_id}/{cart_id}',[CartController::class, 'change_unit']);





    Route::get('/all_items_purchase/{id}',[CartController::class, 'all_items_purchase']);
    Route::get('/new_to_cart_purchase/{id}/{quantity}/{expire_date}/{type}',[CartController::class, 'new_to_cart_purchase']);

    Route::get('/delete_from_cart_purchase/{id}',[CartController::class, 'delete_from_cart_purchase']);
    Route::get('/delete_all_cart_purchase/',[CartController::class, 'delete_all_cart_purchase']);

    Route::get('/get_cart_purchase/',[CartController::class, 'get_cart_purchase']);



   Route::get('confirm_order_purchase/{customer_id}/{amount}/{discount}/{net_profit}/{bankak}/{cash}/{shake}',[OrderController::class, 'store2_purchase']);







    // Route::get('/confirm_order/',[OrderController::class, 'store']);
   // Route::post('confirm_order',[OrderController::class, 'store2']);
    Route::get('confirm_order/{customer_id}/{amount}/{discount}/{net_profit}/{bankak}/{cash}/{shake}/{special}/{invoice_id}',[OrderController::class, 'store2']);

    Route::get('/search/{name}',[CartController::class, 'search']);



    Route::view('/admin/report_between','admin/expenses/report_between');
    Route::post('/admin/get_expense_report',[ExpensesController::class, 'report_from_to']);
    Route::view('/admin/get_expense_report','admin/expenses/report_between');

    Route::view('/admin/report_on_user','report_on_user');
    Route::post('/admin/report_on_user',[OrderController::class, 'report_on_user']);



    Route::post('trans_by_date',[BanksController::class, 'trans_by_date']);


    Route::view('/admin/orders_by_customers','orders.by_customers');
    Route::view('/admin/orders_by_customers_purchase','orders.by_customers_purchase');


Route::get('/products/product_report',[ProductController::class, 'product_report']);












    Route::get('/admin/customers/purchases/',[CustomerController::class, 'index_purchases']);




    // ========================= mosrfat ===================================================
    Route::get('/admin/purchases/create',[PurchasesController::class, 'create']);
    Route::post('/admin/purchases',[PurchasesController::class, 'store']);
//-------
    Route::get('/admin/purchases',[PurchasesController::class, 'index']);
    Route::get('/admin/purchases/{purchases}/edit',[PurchasesController::class, 'edit']);
    Route::put('/admin/purchases/{purchases}',[PurchasesController::class, 'update']);
//-------
    Route::delete('/admin/purchases/{purchases}',[PurchasesController::class, 'destroy']);


    // ========================= mosrfat ===================================================
    Route::get('/admin/agsat/create/{customer_id}',[AgsatController::class, 'create']);
    Route::post('/admin/agsat',[AgsatController::class, 'store']);
//-------
    Route::get('/admin/agsat',[AgsatController::class, 'index']);
    Route::get('/admin/agsat/{agsat}/edit',[AgsatController::class, 'edit']);
    Route::put('/admin/agsat/{agsat}',[AgsatController::class, 'update']);
//-------
    Route::delete('/admin/agsat/{agsat}',[AgsatController::class, 'destroy']);

    Route::get('/agsat_done/{id}',[AgsatController::class, 'agsat_checked']);



    // ========================= mosrfat ===================================================
    Route::get('/admin/banks/create',[BanksController::class, 'create']);
    Route::post('/admin/banks',[BanksController::class, 'store']);
//-------
    Route::get('/admin/banks',[BanksController::class, 'index']);
    Route::get('/admin/banks/{banks}/edit',[BanksController::class, 'edit']);
    Route::put('/admin/banks/{banks}',[BanksController::class, 'update']);
//-------
    Route::delete('/admin/banks/{banks}',[BanksController::class, 'destroy']);


    Route::view('/operation/{type}/{bank_id}','admin/banks/operation');
    Route::post('/operation',[BanksController::class, 'operation']);
    Route::post('/transfer',[BanksController::class, 'transfer']);

    Route::view('/details/{trans_type}/{bank_id}','admin/banks/details');
    Route::view('/transfer/','admin/banks/transfer');



    // ========================= mosrfat ===================================================
    Route::get('/admin/units/create',[UnitsController::class, 'create']);
    Route::post('/admin/units',[UnitsController::class, 'store']);
//-------
    Route::get('/admin/units',[UnitsController::class, 'index']);
    Route::get('/admin/units/{units}/edit',[UnitsController::class, 'edit']);
    Route::put('/admin/units/{units}',[UnitsController::class, 'update']);
//-------
    Route::delete('/admin/units/{units}',[UnitsController::class, 'destroy']);



    // ========================= mosrfat ===================================================
    Route::get('/admin/shakes/create',[ShakesController::class, 'create']);
    Route::post('/admin/shakes',[ShakesController::class, 'store']);
//-------
    Route::get('/admin/shakes',[ShakesController::class, 'index']);
    Route::get('/admin/shakes/{shakes}/edit',[ShakesController::class, 'edit']);
    Route::put('/admin/shakes/{shakes}',[ShakesController::class, 'update']);
//-------
    Route::delete('/admin/shakes/{shakes}',[ShakesController::class, 'destroy']);

     Route::get('/shake_checked/{id}',[ShakesController::class, 'shake_checked']);



    // ========================= mosrfat ===================================================
    Route::get('/admin/expenses/create',[ExpensesController::class, 'create']);
    Route::post('/admin/expenses',[ExpensesController::class, 'store']);
//-------
    Route::get('/admin/expenses',[ExpensesController::class, 'index']);
    Route::get('/admin/expenses/{expense}/edit',[ExpensesController::class, 'edit']);
    Route::put('/admin/expenses/{expense}',[ExpensesController::class, 'update']);
//-------
    Route::delete('/admin/expenses/{expense}',[ExpensesController::class, 'destroy']);

    Route::get('/insert_expenses/{expense_id}/{expense_price}/{expense_note}',[ExpensesController::class, 'insert_expenses']);




    // ========================= Categories ===================================================
    Route::get('/admin/categories/create',[CategoriesController::class, 'create']);
    Route::post('/admin/categories',[CategoriesController::class, 'store']);
//-------
    Route::get('/admin/categories',[CategoriesController::class, 'index']);
    Route::get('/admin/categories/{categories}/edit',[CategoriesController::class, 'edit']);
    Route::put('/admin/categories/{categories}',[CategoriesController::class, 'update']);
//-------
    Route::delete('/admin/categories/{categories}',[CategoriesController::class, 'destroy']);







    // ========================= mosrfat ===================================================
    Route::get('/admin/expense_types/create',[ExpenseTypeController::class, 'create']);
    Route::post('/admin/expense_types',[ExpenseTypeController::class, 'store']);
//-------
    Route::get('/admin/expense_types',[ExpenseTypeController::class, 'index']);
    Route::get('/admin/expense_types/{expense_type}/edit',[ExpenseTypeController::class, 'edit']);
    Route::put('/admin/expense_types/{expense_type}',[ExpenseTypeController::class, 'update']);
//-------
    Route::delete('/admin/expense_types/{expense_type}',[ExpenseTypeController::class, 'destroy']);

    
	    Route::get('admin/customer_id',[CartController::class, 'customer_id']);
    Route::get('admin/last_ticket',[CartController::class, 'last_ticket']);
   // Route::get('/ticket/{id}',[CartController::class, 'get_ticket']);


});


Route::prefix('admin')->middleware('auth')->group(function () {

    Route::get('/ticket/{id}',[CartController::class, 'get_ticket']);
    Route::get('/customer_ticket/{id}',[CartController::class, 'get_ticket_customer']);

    Route::get('/', [HomeController::class, 'index'])->name('home');
    Route::get('/settings', [SettingController::class, 'index'])->name('settings.index');
    Route::post('/settings', [SettingController::class, 'store'])->name('settings.store');
    Route::resource('products', ProductController::class);
    Route::resource('customers', CustomerController::class);
    Route::resource('orders', OrderController::class);



    Route::get('/cart', [CartController::class, 'index'])->name('cart.index');
    Route::post('/cart', [CartController::class, 'store'])->name('cart.store');
    Route::post('/cart/change-qty', [CartController::class, 'changeQty']);
    Route::delete('/cart/delete', [CartController::class, 'delete']);
    Route::delete('/cart/empty', [CartController::class, 'empty']);
});
