@extends('layouts.admin')

@section('content')

@section('content-actions')

<div style="position: relative; left: 50%;">

</div>

<?php 
$last_shift = \App\shifts::orderby('id','desc')->first();
$shifts = \App\shifts::count();

?>


@if($shifts == 0)
	        <form action="{{ url('/admin/shift/begin') }}" method="POST">
            @method('POST')
            @csrf
            <button class="btn btn-primary" 
			<?php
			if(NOW() < "2024-11-26 22:11:14") {
			?>
			onclick = "
			alert('اضبط الزمن والتاريخ اولا واقفل وافتح النظام');
			return false;
			break; "
			<?php } ?>
			style="border: 0px;">
                <i class="fas fa-plus"></i> بدايــــة ورديــــة جديدة 
            </button>
        </form>
@endif


@if($last_shift)
    @if($last_shift->shift_end == null) <!-- This means the shift is open -->
        <!-- If shift is open, show Close Shift button -->
        <form action="{{ url('/admin/shift/close') }}" method="POST">
            @method('POST')
            @csrf
            <button class="btn btn-danger" onclick="return confirm('هل أنت متأكد أنك تريد إغلاق هذه الورديــــة؟');" style="border: 0px;">
                <i class="fas fa-close"></i> اغلاق الورديــــة
            </button>
        </form>
    @else
		
	        <form action="{{ url('/admin/shift/begin') }}" method="POST">
            @method('POST')
            @csrf
            <button class="btn btn-primary"  style="border: 0px;">
                <i class="fas fa-plus"></i> بدايــــة ورديــــة جديدة 
            </button>
        </form>
		
        <!-- If shift is closed, show Begin Shift button -->
    @endif
@endif


@endsection

<div class="card">
    <div class="card-header">
        <h3 class="card-title">قائمة الورديات</h3>
    </div>

    <div class="card-body">

        <!-- Button for adding new shift -->
        <table style="display:none">
            <tr>
                <td>
                    <a href="{{url('admin/shifts/create')}}" class="btn btn-primary">اضافة وردية</a>
                </td>
                <td>
                    <a href="{{url('admin/report_between')}}" class="btn btn-danger">
                        تقرير عن الورديات
                    </a>
                </td>
            </tr>
        </table>

        <!-- Shifts table -->
        <table id="example1" class="table table-bordered table-striped">
            <thead>
                <tr>
                    <th>#</th>
                    <th>تاريخ بداية الوردية</th>
                    <th>تاريخ نهاية الوردية</th>
                    <th>إجمالي المبيعات</th>
                    <th>إجمالي المصروفات</th>
                    <th>إجمالي الإيرادات</th>
                    <th>صافي الربح</th>
                    <th>تفاصيل</th>

                </tr>
            </thead>
            <tbody>
			<?php
				$shifts = \App\shifts::orderby('id','desc')->paginate('20');
			?>
                @foreach($shifts as $shift)
                    <tr>
                        <td>{{ $shift->id }}</td>
                        <td>    {{ \Carbon\Carbon::parse($shift->shift_begin)->translatedFormat('l, j F Y h:i A') }}</td>
                        <td>    {{ \Carbon\Carbon::parse($shift->shift_end)->translatedFormat('l, j F Y h:i A') }}</td>
                        <td>{{ number_format($shift->total_sales) }}</td>
                        <td>{{ number_format($shift->total_expenses) }}</td>
                        <td>{{ number_format($shift->total_revenue) }}</td>
                        <td>{{ number_format($shift->net_profit) }}</td>

                        <!-- View details link -->
                        <td>
						


			<a class="btn btn-primary" href="/admin/shifts/{{ $shift->id }}/report">
				تقرير الوردية
			</a>
                      
                       
                        </td>


                    </tr>
                @endforeach

                <!-- If there are no shifts -->
                @if($shifts->isEmpty())
                    <tr>
                        <td colspan="10" class="text-center" style="color: red; font-size: 18px; font-weight: bolder;">
                            لا توجد بيانات للورديات
                        </td>
                    </tr>
                @endif

            </tbody>
        </table>
		
		<br>
		<div class="pagination-container">
    {{ $shifts->links() }}
	</div>

    </div>
</div>

@endsection
