﻿@extends('layouts.admin')

@section('title', 'المخزن')
@section('content-header', 'قائمة المنتجات ')
@section('content-actions')
<a href="{{route('products.create')}}" class="btn btn-primary">اضافة  منتج جديد</a>
@endsection
@section('css')
<link rel="stylesheet" href="{{ asset('plugins/sweetalert2/sweetalert2.min.css') }}">
@endsection
@section('content')
<div class="card">
    <div class="card-body">
        <table class="table">
            <thead>

                                @if(Config::get('app.locale') == "ar")
                <tr>

                    <th>الاسم</th>

                    <th>السعر</th>


                </tr>

                                @else
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th style="display: none;">Image</th>
                    <th style="display: none;">Barcode</th>
                    <th>Price</th>
                    <th>Quantity</th>
                    <th>Sold</th>
                    <th>Profit</th>
                    <th>Status</th>
                    <th>Updated At</th>
                    <th>Actions</th>
                </tr>

                        @endif
            </thead>
            <tbody>
		<?php $total_value = 0; 
		      $num = 0;
		?>

                @foreach ($products as $product)

		<?php $num = $num + 1; ?>
                <tr>

                    <td>{{$product->name}}</td>
                    <td style="display: none;"><img src="{{url('storage')}}/{{$product->image}}" alt="" width="100"></td>
                    <td style="display: none;">{{$product->barcode}}</td>
                    <td>{{$product->price}}</td>
		</tr>

		@endforeach





            </tbody>
        </table>
        {{ $products->render() }}
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('plugins/sweetalert2/sweetalert2.min.js') }}"></script>
<script>
    $(document).ready(function () {
        $(document).on('click', '.btn-delete', function () {
            $this = $(this);
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger'
                },
                buttonsStyling: false
                })

                swalWithBootstrapButtons.fire({
                title: 'Are you sure?',
                text: "Do you really want to delete this product?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'No',
                reverseButtons: true
                }).then((result) => {
                if (result.value) {
                    $.post($this.data('url'), {_method: 'DELETE', _token: '{{csrf_token()}}'}, function (res) {
                        $this.closest('tr').fadeOut(500, function () {
                            $(this).remove();
                        })
                    })
                }
            })
        })
    })
</script>
@endsection
