@extends('layouts.admin')

@section('title', 'المخزن')
@section('content-header', 'قائمة المنتجات ')
@section('content-actions')
<a href="{{route('products.create')}}" class="btn btn-primary">اضافة  منتج جديد</a>
<a href="{{url('admin/units')}}" class="btn btn-primary"> الوحدات  </a>
<a href="{{url('products/product_report')}}" class="btn btn-primary">تقرير باسعار المنتجات </a>


<a href="{{url('update_prices')}}" class="btn btn-primary"> تحديث الاسعار بنسبة محددة  </a>

@endsection
@section('css')
<link rel="stylesheet" href="{{ asset('plugins/sweetalert2/sweetalert2.min.css') }}">
@endsection
@section('content')
<div class="card">
    <div class="card-body">
        <table class="table">
            <thead>

                                @if(Config::get('app.locale') == "ar")
                <tr>
                    <th>العدد </th>
                    <th>#</th>
                    <th>الاسم</th>
                    <th style="display: none;">الصورة</th>
                    <th style="display: none;">باركود</th>
                    <th>السعر</th>
                    <th style="display:none">الكمية المتبقية</th>
                    <th>الكمية المباعه</th>
                    <th>الربح</th>
                    <th>الحالة</th>
                    <th>التاريخ</th>
                    <th>Actions</th>
                </tr>

                                @else
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th style="display: none;">Image</th>
                    <th style="display: none;">Barcode</th>
                    <th>Price</th>
                    <th>Quantity</th>
                    <th>Sold</th>
                    <th>Profit</th>
                    <th>Status</th>
                    <th>Updated At</th>
                    <th>Actions</th>
                </tr>

                        @endif
            </thead>
            <tbody>

        <?php $total_value = 0; 
              $num = 0;
        ?>

                @foreach ($products as $product)


        <?php $num = $num + 1; ?>


                <tr>
                    <td> {{$num}} </td>
                    <td>{{$product->id}}</td>
                    <td>{{$product->name}}</td>
                    <td style="display: none;"><img src="{{url('storage')}}/{{$product->image}}" alt="" width="100"></td>
                    <td style="display: none;">{{$product->barcode}}</td>
                    <td>{{$product->price}}</td>
                    <td style="display:none">

                    <?php 
                        $refund = 0;
                    $items = \App\Models\OrderItem::where('product_id',$product->id)
                    ->where('type','sale')
                    ->where('item_status','refund')
                    ->get('quantity');
                      
                        
                        foreach($items as $r) {
                            $refund = $refund + $r->quantity;
                        }
                    ?>


                    <?php /*
                        {{$product->quantity + $refund}}
                    */ ?>

                        {{$product->quantity}}


                    </td>
                    <td>

                    <?php 


                        $my_profit = 0;
                        $the_net_profit = 0;
                        $total_sold = 0;
                    $items = \App\Models\OrderItem::where('product_id',$product->id)
                    ->where('type','sale')
                    ->where('item_status','active')
                    ->get();
                      
                        
                        foreach($items as $r) {

                            $total_sold = $total_sold + ($r->quantity / $r->unit->quantity);
                          


                          $cost_of_1 = $product->buy_price / $r->unit->quantity;


                         // dd($cost_of_1);


                            if($r->unit->price > 0) {

                           $the_net_profit = $the_net_profit + 
                           ($r->unit->price - ($product->buy_price / $r->unit->quantity) * ($r->quantity) );

                            } else { 

                           $the_net_profit = $the_net_profit + 
                           ($product->price - $product->buy_price)  * $r->quantity;
                           

                            }
                            

                        }

                        echo $total_sold;



                    ?>

                    </td>

                    <td>

<?php 

                        $my_profit = 0;
                        $total_sold = 0;
                    $items = \App\Models\OrderItem::where('product_id',$product->id)
                    ->where('type','sale')
                    ->where('item_status','active')
                    ->GroupBy('order_id');
                      
                        
                        foreach($items as $r) {

                            $profit = \App\Models\Order::where('id',$r->order_id)->first()->net_profit;
                            $my_profit = $my_profit + $profit;
                        }
?>


                    <?php echo number_format($the_net_profit,0); ?>

                    </td>


                    <td>
                        <span
                            class="right badge badge-{{ $product->status ? 'success' : 'danger' }}">{{$product->status ? 'Active' : 'Inactive'}}</span>
                    </td>

<?php
$total_value = $total_value + ($product->price * $product->quantity);
?>

                    <td>{{$product->updated_at}}</td>
                    <td>

                         <?php //     @if(auth()->user()->id  == '4')  ?>

                        <a href="{{ route('products.edit', $product) }}" class="btn btn-primary"><i
                                class="fas fa-edit"></i></a>

                                <?php /* 
                        <button class="btn btn-danger btn-delete" data-url="{{route('products.destroy', $product)}}"><i
                                class="fas fa-trash"></i></button> */ ?>
                        
                        <?php //    @endif ?>

                    </td>





                </tr>
                @endforeach
            <tr>
                <td style="font-weight:bolder;">
                </td>
                <td style="font-weight:bolder;">
                </td>
                <td style="font-weight:bolder;">
                </td>
                <td style="font-weight:bolder;">
                </td>
                <td style="font-weight:bolder; display:none">
                    اجمالي قيمة المنتجات 
                </td>
                <td style="font-weight:bolder; display:none">
                {{number_format($total_value)}}
                </td>

            </tr>

            </tbody>
        </table>
        {{ $products->render() }}
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('plugins/sweetalert2/sweetalert2.min.js') }}"></script>
<script>
    $(document).ready(function () {
        $(document).on('click', '.btn-delete', function () {
            $this = $(this);
            const swalWithBootstrapButtons = Swal.mixin({
                customClass: {
                    confirmButton: 'btn btn-success',
                    cancelButton: 'btn btn-danger'
                },
                buttonsStyling: false
                })

                swalWithBootstrapButtons.fire({
                title: 'Are you sure?',
                text: "Do you really want to delete this product?",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'Yes, delete it!',
                cancelButtonText: 'No',
                reverseButtons: true
                }).then((result) => {
                if (result.value) {
                    $.post($this.data('url'), {_method: 'DELETE', _token: '{{csrf_token()}}'}, function (res) {
                        $this.closest('tr').fadeOut(500, function () {
                            $(this).remove();
                        })
                    })
                }
            })
        })
    })
</script>
@endsection
