@extends('layouts.admin')

@section('title', 'اضافة منتج ')
@section('content-header', 'اضافة منتج ')

@section('content')

<div class="card">
    <div class="card-body">

        <form action="{{ route('products.store') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="form-group">
                <label for="cat_id">الاقسام </label>

                <?php 
                $cats = \App\categories::all();
                ?>
                <select name="cat_id" id="cat_id" class="form-control">

                    @foreach($cats as $r)
                    <option value="{{$r->id}}">{{$r->title}}</option>
                    @endforeach

                </select>
                @error('cat_id')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
                @enderror
            </div>





            <div class="form-group">
                <label for="name">اسم المنتج</label>
                <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" id="name"
                    placeholder="Name" value="{{ old('name') }}">
                @error('name')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
                @enderror
            </div>






            <input type="hidden" name="description" value="0">

            <input type="hidden" name="little_value" value="0">
            <input type="hidden" name="middle_value" value="0">

            <div class="form-group">
                <label for="image">الصورة  (ان وجدت)</label>
                <div class="custom-file">
                    <input type="file" class="custom-file-input" name="image" id="image">
                    <label class="custom-file-label" for="image">اختر الصورة</label>
                </div>
                @error('image')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
                @enderror
            </div>

            <div class="form-group" style="display:none">
                <label for="barcode">باركود</label>
                <input type="text" name="barcode" class="form-control @error('barcode') is-invalid @enderror"
                    id="barcode" placeholder="barcode"
                     value="<?php
                       $product = \App\Models\Product::orderby('id','desc')->first(); 
                       if($product <> "") {
                        echo $product->barcode + 1;
                       }
                       else
                       {
                        echo "1";
                       }
                      ?>


                     ">
                @error('barcode')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
                @enderror
            </div>

            <div class="form-group">
                <label for="buy_price">سعر الشراء   لأكبر وحدة   </label>
                <input type="text" name="buy_price" class="form-control @error('buy_price') is-invalid @enderror" id="price"
                    placeholder="buy_price" value="{{ old('buy_price') }}">
                @error('buy_price')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
                @enderror
            </div>


            <div class="form-group">
                <label for="price">سعر البيع   لأكبر وحدة  </label>
                <input type="text" name="price" class="form-control @error('price') is-invalid @enderror" id="price"
                    placeholder="price" value="{{ old('price') }}">
                @error('price')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
                @enderror
            </div>

            <div class="form-group" style="display:none;">
                <label for="quantity"> الكمية   بأكبر وحدة بيع     </label>
                <input type="text" name="quantity" class="form-control @error('quantity') is-invalid @enderror"
                    id="quantity" placeholder="Quantity" value="999999999999">
                @error('quantity')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
                @enderror
            </div>

            <div class="form-group" style="display:none">
                <label for="status">الحالة</label>
                <select name="status" class="form-control @error('status') is-invalid @enderror" id="status">
                    <option value="1" {{ old('status') === 1 ? 'selected' : ''}}>فعال</option>
                    <option value="0" {{ old('status') === 0 ? 'selected' : ''}}>غير مفعل</option>
                </select>
                @error('status')
                <span class="invalid-feedback" role="alert">
                    <strong>{{ $message }}</strong>
                </span>
                @enderror
            </div>

            <button class="btn btn-primary" type="submit">اضافة المنتج</button>
        </form>
    </div>
</div>
@endsection

@section('js')
<script src="{{ asset('plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script>
<script>
    $(document).ready(function () {
        bsCustomFileInput.init();
    });
</script>
@endsection