@extends('layouts.auth')

@section('title', 'System Management')

@section('css')

<style>
    .invalid-feedback {
        display: block
    }
</style>
@endsection

@section('content')
<p class="login-box-msg" style="text-align: center;">{{ __('Login') }}</p>

<form action="{{ route('login') }}" style="direction: rtl; text-align: right;" method="post">
    @csrf
    <div class="form-group">

        <div class="input-group">
            <input type="text" name="email" class="form-control @error('email') is-invalid @enderror"
                placeholder="{{ __('Username') }}" value="{{ old('email') }}" required autocomplete="email" autofocus>
            <div class="input-group-append">
                <div class="input-group-text">
                    <span class="fas fa-envelope"></span>
                </div>
            </div>
        </div>
        @error('email')
        <span class="invalid-feedback" role="alert">
            <strong>{{ $message }}</strong>
        </span>
        @enderror
    </div>
    <div class="form-group">

        <div class="input-group">
            <input type="password" class="form-control @error('password') is-invalid @enderror" placeholder="{{ __('Password') }}"
                name="password" required autocomplete="current-password">
            <div class="input-group-append">
                <div class="input-group-text">
                    <span class="fas fa-lock"></span>
                </div>
            </div>
        </div>
        @error('password')
        <span class="invalid-feedback" role="alert">
            <strong>{{ $message }}</strong>
        </span>
        @enderror
    </div>
    <div class="row" >
        <div class="col-8" style="display: none;">
            <div class="icheck-primary">
                <input type="checkbox" name="remember" id="remember" {{ old('remember') ? 'checked' : '' }}>
                <label for="remember">
                    Remember Me
                </label>
            </div>
        </div>
        <!-- /.col -->
        <div class="col-12">
            <button type="submit" class="btn btn-primary btn-block">{{ __('Login') }}</button>
        </div>
        <!-- /.col -->
    </div>
</form>

<p class="mb-1" style="display: none;">
    <a href="{{ route('password.request') }}" style="display: none;">I forgot my password</a>
</p>
<p class="mb-0" style="text-align: center;">
    <a href="{{ route('register')}}" class="text-center">{{__('Register')}}</a>
</p>
@endsection