@extends('layouts.admin')

@section('content')




        <!-- Content Wrapper. Contains car content -->
        <div class="content-wrapper" style="margin-left:10px !important;">
            <!-- Content Header (car header) -->
            <section class="content-header">
                <div class="container-fluid">
                    <div class="row mb-2">
                        <div class="col-sm-6">
                            <h1>انشاء ملف جديد</h1>
                        </div>
                        <div class="col-sm-6">
                            <ol class="breadcrumb float-sm-right">
                                <li class="breadcrumb-item"><a href="#">الرئيسية</a></li>
                                <li class="breadcrumb-item active">ادارة النظام</li>
                            </ol>
                        </div>
                    </div>
                </div><!-- /.container-fluid -->
            </section>









            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-md-12">
                        <div class="success">
                            @if(session()->has('success'))
                                <div class="alert alert-success">
                                    {{ session()->get('success') }}
                                </div>
                            @endif

                                <h2 id="success" style="color: green;
                                font-weight: bolder;">

                                </h2>


                        </div>
                        <form action="{{url('/admin/purchases')}}" method="post" enctype="multipart/form-data">
                            @csrf


                        <div class="form-group">
                            <label for="customer_id"> المورد  </label>
                            
                            <select name="customer_id" class="form-control">
                                <?php $customers = \App\Models\Customer::where('type','purchases')->get(); ?>
                           
                                @foreach($customers as $r)
                                <option value="{{$r->id}}">{{$r->first_name}} {{$r->last_name}}</option>
                                @endforeach

                            </select>
                            @error('title') {{ $message }} @enderror

                        </div>
    

                        <div class="form-group">
                            <label for="title"> المنتج  </label>
                            <input type="text" name="title" id="title" class="form-control" id="title" placeholder="Enter title">
                            @error('title') {{ $message }} @enderror

                        </div>


                        <div class="form-group">
                            <label for="price"> السعر  </label>
                            <input type="number" name="price" id="price" class="form-control" id="price" placeholder="Enter price">
                            @error('price') {{ $message }} @enderror

                        </div>

                        <div class="form-group">
                            <label for="quantity"> الكمية </label>
                            <input type="number" name="quantity" id="quantity" class="form-control" id="quantity" placeholder="Enter quantity">
                            @error('quantity') {{ $message }} @enderror

                        </div>

                        <div class="form-group">
                            <label for="car_no"> ملاحظات </label>
                            <textarea class="form-control" name="details" id="details"></textarea>

                        </div>



                        <div class="card-footer">
                        <button class="btn btn-primary" >اضافة</button>
                        
                        </div>


                        </form>


                    </div>
                    <!-- /.col-->
                </div>
                <!-- ./row -->
            </section>
            <!-- /.content -->
        </div>
        <!-- /.content-wrapper -->





@endsection
