@extends('layouts.admin')

@section('content')

@section('content-actions')
<a href="{{url('admin/categories/create')}}" class="btn btn-primary">اضافة قسم جديد </a>
@endsection

    <div class="card">
        <div class="card-header">
            <h3 class="card-title">قائمة الاقسام </h3>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table id="example1" class="table table-bordered table-striped" style="">
                <thead>
                <tr>
                    <th>#</th>
                    <th>عنوان القسم</th>
                    <th> الكمية المتبقية  </th>
                    <th>تعديل</th>
                    <th>حذف</th>
                </tr>
                </thead>
                <tbody>

@forelse($categories as $categories)

                <tr>
                    <td> {{ $categories->id }}</td>
                    <td> {{ $categories->title }} </td>
                    <?php 
                        $total_products = 0;
                        $products = \App\Models\Product::where('cat_id',$categories->id)
                        ->where('quantity','<>','0')
                        ->get();

                        foreach($products as $r)
                        {
                            $total_products = $total_products + $r->quantity;
                        }

                    ?>  
                    <td> {{ $total_products }} </td>

                    <td>
                        <a class="btn btn-info btn-sm" href="{{url('/admin/categories')}}/{{$categories->id}}/edit">
                            <i class="fas fa-pencil-alt">
                            </i>
                            تعديل
                        </a>
                    </td>


                    <td>
                            <span class="btn btn-danger btn-sm" >
                                <form action="{{url('/admin/categories/')}}/{{ $categories->id }}" method="post">
                                    @method('DELETE')
                                    <button onclick="return confirm('Are you sure you want to delete this ?');" style="border: 0px; background:none; color: white">
                                        <i class="fas fa-trash"></i>
                                        حذف </button>
                                    @csrf
                                </form>


                            </span>

                    </td>



                </tr>

    @empty

    <tr>
       <div style="color: red; font-size: 18px; font-weight: bolder;">لايود بيانات حاليا</div>
    </tr>

                @endforelse










                </tbody>

            </table>
        </div>
        <!-- /.card-body -->
    </div>




@endsection
