<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProductStoreRequest;
use App\Http\Requests\ProductUpdateRequest;
use App\Http\Resources\ProductResource;
use App\Models\Product;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ProductController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function update_prices(){
        $percent = request()->percent;





        $products = Product::all();

        foreach($products as $r) 
        {

            $new_price = $r->price / 100 * $percent;
            $new_buy_price = $r->buy_price / 100 * $percent;


            $r->buy_price = $r->buy_price + $new_buy_price;
            $r->price = $r->price + $new_price;
            $r->update();

        }

        return redirect('update_prices');

    }

    public function all_expiry(Request $request)
    {


        $products = new Product();
        if ($request->search) {
            $products = $products->where('name', 'LIKE', "%{$request->search}%");
        }
        $products = $products->latest()->paginate(100);
        if (request()->wantsJson()) {
            return ProductResource::collection($products);
        }
        return view('products.all_expiry')->with('products', $products);
    }


    public function index_expired(Request $request)
    {


        $products = new Product();
        if ($request->search) {
            $products = $products->where('name', 'LIKE', "%{$request->search}%");
        }
        $products = $products->latest()->paginate(100);
        if (request()->wantsJson()) {
            return ProductResource::collection($products);
        }
        return view('products.expired')->with('products', $products);
    }




    public function product_report(Request $request)
    {
        $products = new Product();
        if ($request->search) {
            $products = $products->where('name', 'LIKE', "%{$request->search}%");
        }
        $products = $products
    // ->latest()
    ->where('quantity','>','0')
    ->Orderby('name','asc')
    ->paginate(10000);
        if (request()->wantsJson()) {
            return ProductResource::collection($products);
        }
        return view('products.product_report')->with('products', $products);
    }



    public function index(Request $request)
    {
        $products = new Product();
        if ($request->search) {
            $products = $products->where('name', 'LIKE', "%{$request->search}%");
        }
        $products = $products->latest()->paginate(10000);
        if (request()->wantsJson()) {
            return ProductResource::collection($products);
        }
        return view('products.index')->with('products', $products);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('products.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(ProductStoreRequest $request)
    {
        $image_path = '';

        if ($request->hasFile('image')) {
           // $image_path = $request->file('image')->store('products', 'public');


     $file = request()->file('image');
     $extension = $file->getClientOriginalExtension(); // you can also use file name
     $fileName = time().'.'.$extension;
     $image_path = public_path().'/storage/products';
     $uplaod = $file->move($image_path,$fileName);

          $image_path = 'products/'.$fileName;


        }



        if($request->image_path == "") {

        $product = Product::create([
            'name' => $request->name,
            'description' => $request->description,
            'image' => 'products/product.jpg',
            'barcode' => $request->barcode,
            'buy_price' => $request->buy_price,
            'price' => $request->price,
            'quantity' => $request->quantity,


            'father_id' => $request->father_id,
            'father_contain_quantity' => $request->father_contain_quantity,

            /*                                                          1   
            'main_unit' => $request->main_unit,
            'middle_unit' => $request->middle_unit,
            'middle_quantity' => $request->middle_unit,
            'middle_value' => $request->middle_value,
            'little_unit' => $request->little_unit,
            'little_quantity' => $request->little_quantity,
            'little_value' => $request->little_value,
            */

            'cat_id' => $request->cat_id,
            'status' => $request->status
        ]);

        }

        else{

        $product = Product::create([
            'name' => $request->name,
            'description' => $request->description,
            'image' => $image_path,
            'barcode' => $request->barcode,
            'buy_price' => $request->buy_price,
            'price' => $request->price,
            'quantity' => $request->quantity,

            'father_id' => $request->father_id,
            'father_contain_quantity' => $request->father_contain_quantity,

/*
            'main_unit' => $request->main_unit,
            'middle_unit' => $request->middle_unit,
            'middle_quantity' => $request->middle_unit,
            'middle_value' => $request->middle_value,
            'little_unit' => $request->little_unit,
            'little_quantity' => $request->little_quantity,
            'little_value' => $request->little_value,
*/


            'cat_id' => $request->cat_id,
            'status' => $request->status
        ]);

        }


        if (!$product) {
            return redirect()->back()->with('خطأ ', 'عفوا حدث خطأ اثناء اضافة المنتج - حاول مرة أخرى ');
        }
        return redirect()->route('products.index')->with('نجاح ', 'تم اضضافة المنتج بنجاح ');
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function show(Product $product)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function edit(Product $product)
    {
        return view('products.edit')->with('product', $product);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function update(ProductUpdateRequest $request, Product $product)
    {
        $product->name = $request->name;
        $product->description = $request->description;
        $product->barcode = $request->barcode;
        $product->buy_price = $request->buy_price;
        $product->price = $request->price;
        $product->quantity = $request->quantity;

/*
        $product->main_unit = $request->main_unit;
        $product->middle_unit = $request->middle_unit;
        $product->middle_quantity = $request->middle_quantity;
        $product->middle_value = $request->middle_value;
        $product->little_unit = $request->little_unit;
        $product->little_quantity = $request->little_quantity;
        $product->little_value = $request->little_value;

        */

        $product->cat_id = $request->cat_id;
        $product->status = $request->status;

        if ($request->hasFile('image')) {
            // Delete old image
            if ($product->image) {
                Storage::delete($product->image);
            }
            // Store image
            //$image_path = $request->file('image')->store('products', 'public');



     $file = request()->file('image');
     $extension = $file->getClientOriginalExtension(); // you can also use file name
     $fileName = time().'.'.$extension;
     $image_path = public_path().'/storage/products';
     $uplaod = $file->move($image_path,$fileName);

     $image_path = 'products/'.$fileName;

            // Save to Database
            $product->image = $image_path;
        }

        if (!$product->save()) {
            return redirect()->back()->with('خطأ ', 'حدث خطأ اثناء تحديث المنتج ');
        }
        return redirect()->route('products.index')->with('نجاح ', 'تم تحديث المنتج بنجاح ');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function destroy(Product $product)
    {
        if ($product->image) {
            Storage::delete($product->image);
        }
        $product->delete();

        return response()->json([
            'success' => true
        ]);
    }
}
