<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Models\Customer;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        $orders = Order::with(['items', 'payments'])->get();
        $customers_count = Customer::count();

        return view('home', [
            'orders_count' => $orders->where('order_status','active')->count(),
            'income' => $orders->map(function($i) {
                if($i->receivedAmount() > $i->total()) {
                    return $i->total();
                }
                return $i->receivedAmount() - $i->discountAmount();
            })->sum(),


            'income_today' => $orders->
            where('status','done')
            ->where('type','sale')
            ->where('order_status','active')
            ->where('created_at', '>=', date('Y-m-d').' 00:00:00')->map(function($i) {
                if($i->receivedAmount() > $i->total()) {
                    return $i->total() - $i->discountAmount();
                }
                return $i->receivedAmount() - $i->discountAmount();
            })->sum(),


            
            'customers_count' => $customers_count
        ]);
    }
}
