<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \App\expense_types;
class ExpenseTypeController extends Controller
{
    
    public function index()
    {
        $expense_types = expense_types::all(); // Select
        return view('admin.expense_types.list' , compact('expense_types')); // while query
    }


    public function create()
    {

        return view('admin.expense_types.create');
    }


    public function store()
    {


        $expense_type = expense_types::create($this->validateData()); // insert
        $this->storeImage($expense_type);
        return redirect('/admin/expense_types/create')->with("success","Created Successfully"); // send id of inserted

    }

    public function show(expense_types $expense_types)
    {
        //
    }


    public function edit(expense_types $expense_type)
    {

        return view('admin.expense_types.edit',compact('expense_type'));
    }


    public function update(Request $request, expense_types $expense_type)
    {


        $expense_type->update($this->validateData());
        $this->storeImage($expense_type);
        return redirect('/admin/expense_types/'. $expense_type->id . "/edit")->with('success', 'successfully updated');

    }


    public function destroy(expense_types $expense_type) {


        $expense_type->delete();
        return redirect('/admin/expense_types');
    }




    private function storeImage($expense_type) {


        if(request()->hasFile('header_img')) {
            $expense_type->update([


            'header_img'=>request()->header_img->store('uploads','public')



            ]);
        }

    }



    protected function validateData() {


        $mydata =  [
            'title'=>'required' ,
        ];

        if(request()->hasFile('header_img')) {
            $mydata['header_img'] = 'file|image';
        }

        $validatedData = request()->validate($mydata);



        return $validatedData;


    }
}
