<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Order;
use Illuminate\Http\Request;
use App\Models\User_Cart;
use App\Models\User_Cart2;
use App\units;
use App\transactions;
use App\banks;


class CartController extends Controller
{


    function change_unit($id,$unit_id,$cart_id) {

        $product = Product::where('id',$id)->first();
        $unit = units::where('id',$unit_id)->first();

       // dd($unit);

        $user_cart = User_Cart::where('user_id',auth()->user()->id)->where('product_id',$id);
                    


                  $user_cart =  User_Cart::where('user_id',auth()->user()->id)->where('id', $cart_id)
                    ->update([
                      'quantity' => '1',
                      'unit_id' => $unit_id,
                      //'price' => $unit->price,
                    ]);

                    $user_cart55 = User_Cart::where('user_id',auth()->user()->id)->where('product_id',$id)
                     ->where('unit_id',$unit_id);

                     if($user_cart55->count() > 1){

                        $u_cart = User_Cart::where('user_id',auth()->user()->id)->where('id',$cart_id);

                        $quantity = $u_cart->first()->quantity;

                        $u_cart->delete();



                    $user_cart =  User_Cart::where('user_id',auth()->user()->id)->where('product_id', $id)
                    ->where('unit_id',$unit_id);

                   $quantity2 = $user_cart->first()->quantity;

                    $user_cart->update([
                    //  'quantity' => ($product->quantity * $unit->quantity),
                      'quantity' => $quantity2 + $quantity,
                      //'price' => $unit->price,
                    ]);



                     }

               
                    /*
                  $user_cart =  User_Cart::where('user_id',auth()->user()->id)->where('product_id', $id)
                   ->where('unit_id',$unit_id)
                    ->update([
                     'quantity' => ($user_cart->quantity + 1),
                      //'unit_id' => $unit_id,
                      //'price' => $unit->price,
                    ]);
*/
                
   


        $cart_data = User_Cart::where('user_id',auth()->user()->id)->Orderby('updated_at','desc')->get();

        return view('cart/user_cart',compact('cart_data'));
    }




    function change_price($id,$price) {

        $product = Product::where('id',$id)->first();



                  $user_cart =  User_Cart::where('user_id',auth()->user()->id)->where('product_id', $id)
                    ->update([
                      'quantity' => ($price / $product->price),
                      'price' => $price,
                    ]);



        $cart_data = User_Cart::where('user_id',auth()->user()->id)->get();

        return view('cart/user_cart',compact('cart_data'));
    }


    function search($name) {

        $products = Product::where('name', 'LIKE', "%$name%")->get();

        return view('cart/all_items',compact('products'));
    }



    function get_cart_purchase() {

        $cart_data = User_Cart2::all();

        return view('cart_purchases/user_cart',compact('cart_data'));
    }

    function get_cart() {

        $cart_data = User_Cart::where('user_id',auth()->user()->id)->get();

        return view('cart/user_cart',compact('cart_data'));
    }

    function delete_all_cart() {

        $product = User_Cart::where('user_id',auth()->user()->id)->where('product_id','>','0');
        $product->delete();

        $cart_data = User_Cart::where('user_id',auth()->user()->id)->get();

        return view('cart/user_cart',compact('cart_data'));
    }


    function delete_all_cart_purchase() {

        $product = User_Cart2::where('product_id','>','0');
        $product->delete();

        $cart_data = User_Cart2::all();

        return view('cart_purchases/user_cart',compact('cart_data'));
    }


    function delete_from_cart($id) {

        $product = User_Cart::where('id',$id);
        $product->delete();

        $cart_data = User_Cart::where('user_id',auth()->user()->id)->get();

        return view('cart/user_cart',compact('cart_data'));
    }


    function delete_from_cart_purchase($id) {

        $product = User_Cart2::where('product_id',$id);
        $product->delete();

        $cart_data = User_Cart2::all();

        return view('cart_purchases/user_cart',compact('cart_data'));
    }










    public function new_to_cart_purchase($id,$quantity,$expire_date,$type) {

        $product = \App\Models\Product::where('id',$id)->orWhere('barcode',$id)->first();

        $id = $product->id;
        
        $product_exist = User_Cart2::where('product_id',$id)->first();

        // echo $product_exist;

        if($product_exist == "") {
        $user_cart = new User_Cart2();
        $user_cart->product_id = $id;
        $user_cart->quantity = $quantity;
        $user_cart->expire_date = $expire_date;
        $user_cart->user_id = auth()->user()->id;
        $user_cart->save();
       // echo "inserted";
        //echo "here";

        $cart_data = User_Cart2::all();

        return view('cart_purchases/user_cart',compact('cart_data'));

        }

        else if ($quantity <> 1) {

                  $user_cart =  User_Cart2::where('product_id', $id)
                    ->update([
                      'quantity' => $quantity,
                      'expire_date' => $expire_date,
                    ]);

        $cart_data = User_Cart2::all();

        return view('cart_purchases/user_cart',compact('cart_data'));

        }
        else if($quantity == 1 && $type=='product') {

      $user_cart =  User_Cart2::where('product_id', $id)
                    ->update([
                      'quantity' => $product_exist->quantity + 1,
                      'expire_date' => $expire_date,
                    ]);

        $cart_data = User_Cart2::all();

        return view('cart_purchases/user_cart',compact('cart_data'));

       //  echo $product_exist->quantity;
           // echo "updated";
        }


                else if($quantity == 1 && $type=='date') {

      $user_cart =  User_Cart2::where('product_id', $id)
                    ->update([
                      'quantity' => $quantity,
                      'expire_date' => $expire_date,
                    ]);

        $cart_data = User_Cart2::all();

        return view('cart_purchases/user_cart',compact('cart_data'));

       //  echo $product_exist->quantity;
           // echo "updated";
        }

        $cart_data = User_Cart2::all();


        return view('cart_purchases/user_cart',compact('cart_data'));


    }




















    public function new_to_cart($id,$quantity,$unit_id,$product_id) {



       // if($id > 0) {

      //  $cart = \App\Models\User_Cart::where('id',$id)->first();

        $cart_id = $id;
        $id = $product_id;

    //  $product = \App\Models\Product::where('id',$cart->product_id)->orWhere('barcode',$id)->first();
      $product = \App\Models\Product::where('id',$product_id)->first();
      $the_unit = \App\units::where('id',$unit_id)->first();

        
        

        $product_exist = User_Cart::where('user_id',auth()->user()->id)->where('product_id',$id)
        ->where('unit_id',$unit_id)
        ->first();


        // echo $product_exist;

        if($product_exist == "") {
        $user_cart = new User_Cart();

        $unit = \App\units::where('product_id',$id)->Orderby('quantity','asc')->first();

        if($unit <> "") {
        $user_cart->unit_id = $unit->id;
        }
        else
        {
        $user_cart->unit_id = 0;
        }

        $user_cart->product_id = $id;
        $user_cart->quantity = 1;
        $user_cart->user_id = auth()->user()->id;
        $user_cart->save();
       // echo "inserted";
        //echo "here";

        $cart_data = User_Cart::where('user_id',auth()->user()->id)->Orderby('updated_at','desc')
        //->groupby('unit_id')
        ->get();

        return view('cart/user_cart',compact('cart_data'));

        }

        else if ($quantity >= 1) {





        if($quantity > ($product->quantity * $the_unit->quantity)) {

                  $user_cart =  User_Cart::where('user_id',auth()->user()->id)->where('product_id', $id)
                    ->update([
                      'quantity' => $product->quantity * $the_unit->quantity,
                    ]);
        } else {


                  $user_cart =  User_Cart::where('id', $cart_id)
                    ->update([
                      'quantity' => $quantity,
                    ]);
            }

        $cart_data = User_Cart::where('user_id',auth()->user()->id)->Orderby('updated_at','desc')->get();

        return view('cart/user_cart',compact('cart_data'));

        }
        else if($quantity == 0) {

      $user_cart =  User_Cart::where('user_id',auth()->user()->id)->where('product_id', $id)
                    ->update([
                      'quantity' => $product_exist->quantity + 1,
                    ]);

        $cart_data = User_Cart::where('user_id',auth()->user()->id)->Orderby('updated_at','desc')->get();

        return view('cart/user_cart',compact('cart_data'));

       //  echo $product_exist->quantity;
           // echo "updated";

        }



        if($quantity > ($product->quantity * $the_unit->quantity)) {

                  $user_cart =  User_Cart::where('user_id',auth()->user()->id)->where('product_id', $id)
                    ->update([
                      'quantity' => $product->quantity * $the_unit->quantity,
                    ]);

        $cart_data = User_Cart::where('user_id',auth()->user()->id)->Orderby('updated_at','desc')->get();

        return view('cart/user_cart',compact('cart_data'));

        }




    }


    public function all_items($id) {
        $products = Product::where('cat_id',$id)->where('status','1')->get();

        return view('cart/all_items',compact('products'));

    }


    public function all_items_purchase($id) {
        $products = Product::where('cat_id',$id)->where('status','1')->get();

        return view('cart_purchases/all_items',compact('products'));

    }


    public function last_ticket() {
        $order = Order::orderby('id','desc')->first();

        return view('ticket',compact('order'));

    }


    public function get_ticket($id) {
        $order = Order::where('id',$id)->first();

        return view('ticket',compact('order'));

    }

    public function get_ticket_customer($id) {
        $order = Order::where('customer_id',$id)
        ->where('status','not_done')
        ->first();

        

        return view('ticket',compact('order'));

    }

    public function customer_id() {
        $order = Order::orderby('id','desc')->first();

        return view('customer_id',compact('order'));

    }

    public function index(Request $request)
    {
        if ($request->wantsJson()) {
            return response(
                $request->user()->cart()->get()
            );
        }
        return view('cart.index');
    }

    public function store(Request $request)
    {
        $request->validate([
            'barcode' => 'required|exists:products,barcode',
        ]);
        $barcode = $request->barcode;

        $cart = $request->user()->cart()->where('barcode', $barcode)->first();
        if ($cart) {
            // update only quantity
            $cart->pivot->quantity = $cart->pivot->quantity + 1;
            $cart->pivot->save();
        } else {
            $product = Product::where('barcode', $barcode)->first();
            $request->user()->cart()->attach($product->id, ['quantity' => 1]);
        }

        return response('', 204);
    }

    public function changeQty(Request $request)
    {
        $request->validate([
            'product_id' => 'required|exists:products,id',
            'quantity' => 'required|integer|min:1',
        ]);

        $cart = $request->user()->cart()->where('id', $request->product_id)->first();

        if ($cart) {
            $cart->pivot->quantity = $request->quantity;
            $cart->pivot->save();
        }

        return response([
            'success' => true
        ]);
    }

    public function delete(Request $request)
    {
        $request->validate([
            'product_id' => 'required|integer|exists:products,id'
        ]);
        $request->user()->cart()->detach($request->product_id);

        return response('', 204);
    }

    public function empty(Request $request)
    {
        $request->user()->cart()->detach();

        return response('', 204);
    }
}
