<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \App\banks;
use \App\transactions;

class BanksController extends Controller
{
    
    public function trans_by_date(Request $request){


         $transactions =  \App\transactions::where('id','>','0');

        $bank_id = request()->bank_id;

        if($request->bank_id == '3') {
            $transactions = $transactions->where('payment_method', 'cash');
        }

        if($request->bank_id == '4') {
            $transactions = $transactions->where('payment_method', 'bankak');
        }        

        if($request->bank_id > '4') {
            $transactions = $transactions->where('trans_type', 'banks')->where('trans_type_id',$request->bank_id);
        } 

        if($request->date_from) {
            $transactions = $transactions->where('created_at', '>=', $request->date_from);
        }
        if($request->date_to) {
            $transactions = $transactions->where('created_at', '<=', $request->date_to . ' 23:59:59');
        }


        $transactions = $transactions->get();

        //dd($transactions);

        return view('admin/banks/details_by_date',compact('transactions','bank_id'));




    }


    public function transfer() {


        $type = 'depit';
        $bank_id = request()->account_from;
        $amount = request()->amount;
        if($bank_id == 3) {
        $payment_method = 'cash';
        }

        else if($bank_id == 4) {
        $payment_method = 'bankak';
        }

        if($bank_id > 4) {
        $payment_method = 'transfer';
        }

        $notes = request()->notes;


        $trans = new transactions;
        $trans->type = $type;
        $trans->amount = $amount;
        $trans->payment_method = $payment_method;

        $notes = "تحويل من  ".
        \App\banks::where('id',$bank_id)->first()->bank.
        " الى حساب   ".\App\banks::where('id',request()->account_to)->first()->bank

        ."  ".request()->notes;


        $trans->trans_type = "banks";
        $trans->trans_type_id = $bank_id;
        $trans->save();
        $banks = banks::where('id',$bank_id)->first();
        if($type == "credit") {
        $banks->balance = $banks->balance + $amount;
        }
        if($type == "depit") {
        $banks->balance = $banks->balance - $amount;
        }
        $banks->update();



///////////// Account To //////////////////////
        $type2 = 'credit';
        $bank_id2 = request()->account_to;
        $amount2 = request()->amount;

        if($bank_id2 == 3) {
        $payment_method2 = 'cash';
        }

        else if($bank_id2 == 4) {
        $payment_method2 = 'bankak';
        }

        if($bank_id2 > 4) {
        $payment_method2 = 'transfer';
        }


        $notes2 = "تحويل من  ".
        \App\banks::where('id',$bank_id)->first()->bank.
        " الى حساب   ".\App\banks::where('id',request()->account_to)->first()->bank

        ."  ".request()->notes;


        $trans2 = new transactions;
        $trans2->type = $type2;
        $trans2->amount = $amount2;
        $trans2->payment_method = $payment_method2;
        $trans2->notes = $notes2;
        $trans2->trans_type = "banks";
        $trans2->trans_type_id = $bank_id2;
        $trans2->save();
        $banks = banks::where('id',$bank_id2)->first();
        if($type == "credit") {
        $banks->balance = $banks->balance + $amount;
        }
        if($type == "depit") {
        $banks->balance = $banks->balance - $amount;
        }
        $banks->update();





        return redirect('admin/banks');

    }


    public function operation() {
        $type = request()->type;
        $bank_id = request()->bank_id;
        $amount = request()->amount;
        $payment_method = request()->payment_method;
        $notes = request()->notes;


        $trans = new transactions;
        $trans->type = $type;
        $trans->amount = $amount;
        $trans->payment_method = $payment_method;
        $trans->notes = $payment_method.'  '.$notes;
        $trans->trans_type = "banks";
        $trans->trans_type_id = $bank_id;
        $trans->save();

        $banks = banks::where('id',$bank_id)->first();

        if($type == "credit") {
        $banks->balance = $banks->balance + $amount;
        }
        if($type == "depit") {
        $banks->balance = $banks->balance - $amount;
        }

        $banks->update();

        return redirect('admin/banks');

    }

    public function index()
    {
        $banks = banks::all(); // Select
        return view('admin.banks.list' , compact('banks')); // while query
    }


    public function create()
    {

        return view('admin.banks.create');
    }


    public function store()
    {


        $banks = banks::create($this->validateData()); // insert
        $this->storeImage($banks);
        return redirect('/admin/banks/create')->with("success","Created Successfully"); // send id of inserted

    }

    public function show(banks $banks)
    {
        //
    }


    public function edit(banks $banks)
    {
        return view('admin.banks.edit',compact('banks'));
    }


    public function update(Request $request, banks $banks)
    {


        $banks->update($this->validateData());
        $this->storeImage($banks);
        return redirect('/admin/banks/'. $banks->id . "/edit")->with('success', 'successfully updated');

    }


    public function destroy(banks $banks) {

      //  dd($banks->id);

        $transactions = \App\transactions::where('trans_type','banks')
        ->where('trans_type_id',$banks->id);

        $transactions->delete();
        $banks->delete();
        return redirect('/admin/banks');
    }




    private function storeImage($banks) {


        if(request()->hasFile('header_img')) {
            $banks->update([


            'header_img'=>request()->header_img->store('uploads','public')



            ]);
        }

    }



    protected function validateData() {


        $mydata =  [
            'bank'=>'required' ,

        ];

        if(request()->hasFile('header_img')) {
            $mydata['header_img'] = 'file|image';
        }

        $validatedData = request()->validate($mydata);



        return $validatedData;


    }
}
